/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client.sse;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class FixedSizeStream
extends InputStream {
    private static final int MAGIC_BYTE = 42;
    private final int size;
    private int sent = 0;

    public FixedSizeStream(int responseSize) {
        this.size = responseSize;
    }

    @Override
    public int read() throws IOException {
        if (this.sent < this.size) {
            ++this.sent;
            return 42;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        len = Math.min(len, this.available());
        Arrays.fill(b, off, off + len, (byte)42);
        this.sent += len;
        return len;
    }

    @Override
    public int available() {
        return this.size - this.sent;
    }
}

