/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import org.mule.service.http.netty.impl.client.ReactorNettyClient;

public class RedirectMethodChangeHandler
extends ChannelDuplexHandler {
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            if (RedirectMethodChangeHandler.shouldChangeMethodToGET(ctx)) {
                request.setMethod(HttpMethod.GET);
                if (RedirectMethodChangeHandler.shouldOverrideBodyWithEmpty(ctx)) {
                    request.headers().remove("Transfer-Encoding");
                    request.headers().set("Content-Length", (Object)"0");
                }
            }
        }
        super.write(ctx, msg, promise);
    }

    private static boolean shouldOverrideBodyWithEmpty(ChannelHandlerContext ctx) {
        return Boolean.FALSE.equals(ctx.channel().attr(ReactorNettyClient.ALWAYS_SEND_BODY_KEY).get());
    }

    private static boolean shouldChangeMethodToGET(ChannelHandlerContext ctx) {
        return Boolean.TRUE.equals(ctx.channel().attr(ReactorNettyClient.REDIRECT_CHANGE_METHOD).get());
    }
}

