/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.service.http.netty.impl.server.NettyHttp2RequestReadyCallback;
import org.mule.service.http.netty.impl.server.NettyHttpRequestContext;
import org.mule.service.http.netty.impl.server.util.DefaultServerAddress;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.impl.streaming.BlockingBidirectionalStream;

public class NettyToMuleHttp2RequestHandlerAdapter
extends SimpleChannelInboundHandler<Object> {
    public static final char PSEUDO_HEADER_PREFIX = ':';
    private final HttpListenerRegistry httpListenerRegistry;
    private final SslHandler sslHandler;
    private final BlockingBidirectionalStream bidiStream;

    public NettyToMuleHttp2RequestHandlerAdapter(HttpListenerRegistry httpListenerRegistry, SslHandler sslHandler) {
        this.httpListenerRegistry = httpListenerRegistry;
        this.sslHandler = sslHandler;
        this.bidiStream = new BlockingBidirectionalStream();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2DataFrame) {
            Http2DataFrame dataFrame = (Http2DataFrame)msg;
            this.onDataFrameRead(dataFrame);
        } else if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            this.onHeadersFrameRead(ctx, headersFrame);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    private void onHeadersFrameRead(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) throws IOException {
        if (headersFrame.isEndStream()) {
            this.bidiStream.getOutputStream().close();
        }
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().localAddress();
        DefaultServerAddress serverAddress = new DefaultServerAddress(socketAddress.getAddress(), socketAddress.getPort());
        String uriString = headersFrame.headers().path().toString();
        InputStreamHttpEntity entity = new InputStreamHttpEntity(this.bidiStream.getInputStream());
        HttpRequestBuilder requestBuilder = (HttpRequestBuilder)HttpRequest.builder().protocol(HttpProtocol.HTTP_2).method(headersFrame.headers().method().toString()).uri(uriString).entity((HttpEntity)entity);
        MultiMap queryParams = HttpEncoderDecoderUtils.decodeQueryString((String)HttpEncoderDecoderUtils.extractQueryParams((String)uriString));
        requestBuilder.queryParams(queryParams);
        for (Map.Entry entry : headersFrame.headers()) {
            CharSequence headerName = (CharSequence)entry.getKey();
            if (headerName.charAt(0) == ':') continue;
            CharSequence headerValue = (CharSequence)entry.getValue();
            requestBuilder.addHeader(headerName.toString(), headerValue.toString());
        }
        HttpRequest request = requestBuilder.build();
        RequestHandler requestHandler = this.httpListenerRegistry.getRequestHandler(serverAddress, request);
        requestHandler.handleRequest((HttpRequestContext)new NettyHttpRequestContext(request, ctx, this.sslHandler), (HttpResponseReadyCallback)new NettyHttp2RequestReadyCallback(ctx, headersFrame.stream()));
    }

    private void onDataFrameRead(Http2DataFrame dataFrame) throws IOException {
        ByteBuf content = dataFrame.content();
        byte[] data = ByteBufUtil.getBytes((ByteBuf)content);
        this.bidiStream.getOutputStream().write(data);
        if (dataFrame.isEndStream()) {
            this.bidiStream.getOutputStream().close();
        }
    }
}

