/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl.configuration;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.ast.api.exception.PropertyNotFoundException;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;

public class OpenTelemetryAutoConfigurableLoggingConfiguration
implements ObservabilitySignalConfiguration {
    public static final String HTTP_EXPORTER_TYPE = "HTTP";
    public static final String GRPC_EXPORTER_TYPE = "GRPC";
    public static final String DEFAULT_GRPC_EXPORTER_ENDPOINT = "http://localhost:4317";
    public static final String DEFAULT_HTTP_EXPORTER_ENDPOINT = "http://localhost:4318/v1/logs";
    public static final String DEFAULT_BACKOFF_MULTIPLIER = "1.5";
    public static final String DEFAULT_INITIAL_BACKOFF = "1";
    public static final String DEFAULT_MAXIMUM_BACKOFF = "5";
    public static final String DEFAULT_BACKOFF_MAX_ATTEMPTS = "5";
    public static final String DEFAULT_EXPORTER_TYPE = "HTTP";
    public static final String DEFAULT_EXPORTER_TIMEOUT = "10000";
    public static final Long DEFAULT_BATCH_SCHEDULE_DELAY_MILLIS = 1000L;
    public static final String DEFAULT_BATCH_QUEUE_SIZE = "2048";
    public static final String DEFAULT_BATCH_MAX_BATCH_SIZE = "512";
    public static final String DEFAULT_SERVICE_NAMESPACE = "mule";
    public static final String DEFAULT_BATCH_BACKPRESSURE_STRATEGY = "BLOCK";
    private final ObservabilitySignalConfiguration delegate;
    private final Map<String, String> defaultConfigurationValues = new HashMap<String, String>();

    public OpenTelemetryAutoConfigurableLoggingConfiguration(ObservabilitySignalConfiguration delegate) {
        this.delegate = delegate;
        this.initializeConfigurationValues();
    }

    public String getStringValue(String key) {
        try {
            return this.delegate.getStringValue(key, this.defaultConfigurationValues.get(key));
        }
        catch (PropertyNotFoundException e) {
            return this.defaultConfigurationValues.get(key);
        }
    }

    private void initializeConfigurationValues() {
        this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.enabled", "false");
        this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.type", "HTTP");
        if (this.getStringValue("mule.openTelemetry.logging.exporter.type", "HTTP").equals(GRPC_EXPORTER_TYPE)) {
            this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.endpoint", DEFAULT_GRPC_EXPORTER_ENDPOINT);
        } else {
            this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.endpoint", DEFAULT_HTTP_EXPORTER_ENDPOINT);
        }
        this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.timeout", DEFAULT_EXPORTER_TIMEOUT);
        this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.backoff.multiplier", DEFAULT_BACKOFF_MULTIPLIER);
        this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.backoff.initial", DEFAULT_INITIAL_BACKOFF);
        this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.backoff.maximum", "5");
        this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.backoff.maxAttempts", "5");
        this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.batch.queueSize", DEFAULT_BATCH_QUEUE_SIZE);
        this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.batch.maxSize", DEFAULT_BATCH_MAX_BATCH_SIZE);
        this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporter.batch.backPressure.strategy", DEFAULT_BATCH_BACKPRESSURE_STRATEGY);
        this.defaultConfigurationValues.put("mule.openTelemetry.logging.exporterresource.service.namespace", DEFAULT_SERVICE_NAMESPACE);
    }
}

