/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.service.http.test.netty.utils.TestHttp2RequestHandler;
import org.mule.service.http.test.netty.utils.client.TestSSLNettyClientWithBouncyCastle;
import org.mule.tck.junit4.rule.DynamicPort;

public class NettyHttpServerWithBouncyCastleTestCase
extends AbstractHttpTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public TestSSLNettyClientWithBouncyCastle testClient = new TestSSLNettyClientWithBouncyCastle("localhost", this.serverPort.getNumber());
    private HttpServer serverWithSSLContext;
    private HttpListenerRegistry listenerRegistry;

    @Before
    public void setup() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.listenerRegistry = new HttpListenerRegistry();
    }

    @After
    public void tearDown() {
        Security.removeProvider("BC");
        if (this.serverWithSSLContext != null) {
            this.serverWithSSLContext.stop().dispose();
        }
    }

    private void initiateServerWithSslContext(String keystorePath, String keystorePassword, String keyAlias, String truststorePath, String truststorePassword) throws NoSuchAlgorithmException, CreateException, KeyManagementException, IOException {
        SslContext serverSslContext = this.createSslContext(keystorePath, keystorePassword, keyAlias, truststorePath, truststorePassword);
        this.serverWithSSLContext = NettyHttpServer.builder().withName("test-server").withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withHttpListenerRegistry(this.listenerRegistry).withSslContext(serverSslContext).withShutdownTimeout(() -> 5000L).withClientChannelHandler(new AcceptedConnectionChannelInitializer(this.listenerRegistry, "test-server", true, 30000, 10000L, serverSslContext, 300, (ExecutorService)executorRule.getExecutor())).build();
        this.serverWithSSLContext.start();
        this.serverWithSSLContext.addRequestHandler("/path", (RequestHandler)new TestHttp2RequestHandler());
        this.serverWithSSLContext.addRequestHandler(Collections.singleton("GET"), "/only-get", (RequestHandler)new TestHttp2RequestHandler());
    }

    private SslContext createSslContext(String keystorePath, String keystorePassword, String keyAlias, String truststorePath, String truststorePassword) throws NoSuchAlgorithmException, KeyManagementException, CreateException {
        TlsContextFactory tlsContextFactory = TlsContextFactory.builder().keyStorePath(keystorePath).keyStorePassword(keystorePassword).keyAlias(keyAlias).keyPassword(keystorePassword).trustStorePath(truststorePath).trustStorePassword(truststorePassword).insecureTrustStore(true).build();
        return new JdkSslContext(tlsContextFactory.createSslContext(), false, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}), ClientAuth.NONE, null, false);
    }

    @Test
    @Issue(value="W-15631497")
    public void testSSLConnection() throws Exception {
        this.initiateServerWithSslContext("serverKeystore", "mulepassword", "muleserver", "trustStore", "mulepassword");
        String sslEndpoint = "/path";
        HttpResponse response = this.testClient.sendGet(sslEndpoint);
        MatcherAssert.assertThat((String)"Expected response status code to be 200", (Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    @Issue(value="W-15631497")
    public void testSSLRehandshake() throws Exception {
        this.initiateServerWithSslContext("serverKeystore", "mulepassword", "muleserver", "trustStore", "mulepassword");
        String sslEndpoint = "/path";
        HttpResponse initialResponse = this.testClient.sendGet(sslEndpoint);
        MatcherAssert.assertThat((Object)initialResponse.getStatusCode(), (Matcher)Matchers.is((Object)200));
        this.testClient.reHandshake();
        HttpResponse rehandshakeResponse = this.testClient.sendGet(sslEndpoint);
        MatcherAssert.assertThat((Object)rehandshakeResponse.getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    @Issue(value="W-15631497")
    public void testSSLHandshakeFailureWhenKeystorePasswordIsIncorrect() {
        try {
            this.initiateServerWithSslContext("serverKeystore", "wrongpassword", "muleserver", "trustStore", "mulepassword");
            this.testClient.sendGet("/path");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)"Unable to initialise TLS configuration", (Matcher)Matchers.is((Object)e.getMessage()));
        }
    }

    @Test
    @Issue(value="W-15631497")
    public void testSSLHandshakeFailureWhenTrustStorePasswordIsIncorrect() {
        try {
            this.initiateServerWithSslContext("serverKeystore", "mulepassword", "muleserver", "trustStore", "wrongpassword");
            this.testClient.sendGet("/path");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)"Unable to initialise TLS configuration", (Matcher)Matchers.is((Object)e.getMessage()));
        }
    }
}

