/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.sdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.mule.weave.v2.sdk.BinaryWeaveResource;
import org.mule.weave.v2.sdk.DefaultWeaveResource;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.utils.WeaveConstants$;
import scala.io.BufferedSource;
import scala.io.Source$;

public final class WeaveResourceFactory$ {
    public static WeaveResourceFactory$ MODULE$;

    static {
        new WeaveResourceFactory$();
    }

    public WeaveResource fromContent(String content) {
        return this.fromContent("Unknown", content);
    }

    public WeaveResource fromContent(String url, String content) {
        return WeaveResource$.MODULE$.apply(url, content);
    }

    public BinaryWeaveResource fromBinaryInputStream(InputStream binaryContent, WeaveResource sourceWeaveResource) {
        BinaryWeaveResource binaryWeaveResource;
        try {
            binaryWeaveResource = new BinaryWeaveResource(binaryContent.readAllBytes(), sourceWeaveResource);
        }
        finally {
            if (binaryContent != null) {
                binaryContent.close();
            }
        }
        return binaryWeaveResource;
    }

    public BinaryWeaveResource fromBinaryFile(File binaryFile, WeaveResource sourceWeaveResource) {
        BinaryWeaveResource binaryWeaveResource;
        try (FileInputStream inputStream = new FileInputStream(binaryFile);){
            binaryWeaveResource = new BinaryWeaveResource(inputStream.readAllBytes(), sourceWeaveResource);
        }
        return binaryWeaveResource;
    }

    public WeaveResource fromFile(File file) {
        DefaultWeaveResource defaultWeaveResource;
        try (BufferedSource source = Source$.MODULE$.fromFile(file, WeaveConstants$.MODULE$.default_encoding());){
            defaultWeaveResource = WeaveResource$.MODULE$.apply(file.toURI().toURL().toExternalForm(), source.mkString());
        }
        return defaultWeaveResource;
    }

    public WeaveResource fromInputStream(String url, InputStream content) {
        DefaultWeaveResource defaultWeaveResource;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(content, WeaveConstants$.MODULE$.default_encoding());){
            defaultWeaveResource = WeaveResource$.MODULE$.apply(url, source.mkString());
        }
        return defaultWeaveResource;
    }

    public WeaveResource fromUrl(URL url) {
        DefaultWeaveResource defaultWeaveResource;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(url.openStream(), WeaveConstants$.MODULE$.default_encoding());){
            defaultWeaveResource = WeaveResource$.MODULE$.apply(url.toExternalForm(), source.mkString());
        }
        return defaultWeaveResource;
    }

    private WeaveResourceFactory$() {
        MODULE$ = this;
    }
}

