/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import javax.transaction.xa.XAResource;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.tx.MuleXaObject;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.transaction.XaTransaction;
import org.mule.runtime.core.internal.transaction.xa.IllegalTransactionStateException;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionalResource;
import org.mule.sdk.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAExtensionTransactionalResource<T extends XATransactionalConnection>
extends ExtensionTransactionalResource<T>
implements MuleXaObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAExtensionTransactionalResource.class);
    private XAResource enlistedXAResource;
    private volatile boolean reuseObject = false;

    public XAExtensionTransactionalResource(T connection, ConnectionHandler<T> connectionHandler, Transaction transaction) {
        super(connection, connectionHandler, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlist() throws TransactionException {
        XaTransaction transaction = this.getTransaction();
        XAExtensionTransactionalResource xAExtensionTransactionalResource = this;
        synchronized (xAExtensionTransactionalResource) {
            XAResource xaResource;
            boolean wasAbleToEnlist;
            if (!this.isEnlisted() && (wasAbleToEnlist = transaction.enlistResource(xaResource = ((XATransactionalConnection)this.getConnection()).getXAResource()))) {
                this.enlistedXAResource = xaResource;
            }
        }
        return this.isEnlisted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delist() throws Exception {
        if (!this.isEnlisted()) {
            return false;
        }
        XaTransaction transaction = this.getTransaction();
        XAExtensionTransactionalResource xAExtensionTransactionalResource = this;
        synchronized (xAExtensionTransactionalResource) {
            boolean wasAbleToDelist;
            if (this.isEnlisted() && (wasAbleToDelist = transaction.delistResource(this.enlistedXAResource, 0x4000000))) {
                this.enlistedXAResource = null;
            }
            return !this.isEnlisted();
        }
    }

    public void close() throws Exception {
        block2: {
            try {
                this.getConnectionHandler().release();
            }
            catch (Exception e) {
                if (!LOGGER.isInfoEnabled()) break block2;
                LOGGER.info("Exception while explicitly closing the xaConnection (some providers require this). The exception will be ignored and only logged: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean isReuseObject() {
        return this.reuseObject;
    }

    public void setReuseObject(boolean reuseObject) {
        this.reuseObject = reuseObject;
    }

    public Object getTargetObject() {
        return this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnlisted() {
        XAExtensionTransactionalResource xAExtensionTransactionalResource = this;
        synchronized (xAExtensionTransactionalResource) {
            return this.enlistedXAResource != null;
        }
    }

    private XaTransaction getTransaction() throws TransactionException {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (transaction == null) {
            throw new IllegalTransactionStateException(CoreMessages.noMuleTransactionAvailable());
        }
        if (!(transaction instanceof XaTransaction)) {
            throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction((Object)transaction));
        }
        return (XaTransaction)transaction;
    }
}

