/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.management.stats.FlowsSummaryStatistics;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperation;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationCallback;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultArgumentDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultTroubleshootingOperationDefinition;

public class StatisticsOperation
implements TroubleshootingOperation {
    public static final String STATISTICS_OPERATION_NAME = "statistics";
    public static final String STATISTICS_OPERATION_DESCRIPTION = "Collects statistics information from all deployed applications";
    public static final String APPLICATION_ARGUMENT_NAME = "application";
    public static final String APPLICATION_ARGUMENT_DESCRIPTION = "Application to collect statistics from";
    private static final TroubleshootingOperationDefinition definition = StatisticsOperation.createOperationDefinition();
    private final DeploymentService deploymentService;

    public StatisticsOperation(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @Override
    public TroubleshootingOperationDefinition getDefinition() {
        return definition;
    }

    @Override
    public TroubleshootingOperationCallback getCallback() {
        return (arguments, writer) -> {
            String applicationName = (String)arguments.get(APPLICATION_ARGUMENT_NAME);
            if (applicationName == null) {
                this.writeStatisticsForAllApplications(writer);
            } else {
                Application application = this.deploymentService.findApplication(applicationName);
                if (application != null) {
                    StatisticsOperation.writeStatisticsFor(application, writer);
                } else {
                    writer.write("Application '" + applicationName + "' not found." + System.lineSeparator());
                }
            }
        };
    }

    private void writeStatisticsForAllApplications(Writer writer) throws IOException {
        List applications = this.deploymentService.getApplications();
        if (!applications.isEmpty()) {
            for (Application app : applications) {
                StatisticsOperation.writeStatisticsFor(app, writer);
            }
        } else {
            writer.write("No applications deployed." + System.lineSeparator());
        }
    }

    private static void writeStatisticsFor(Application app, Writer writer) throws IOException {
        AllStatistics appStats;
        ArtifactContext artifactContext = app.getArtifactContext();
        if (artifactContext != null && (appStats = artifactContext.getMuleContext().getStatistics()) != null) {
            String appTitle = "Statistics for application '" + app.getArtifactName() + "'";
            writer.write(appTitle + System.lineSeparator());
            writer.write(StringUtils.leftPad((String)"", (int)appTitle.length(), (String)"-") + System.lineSeparator());
            writer.write(System.lineSeparator());
            StatisticsOperation.writeFlowSummaryStatistics(appStats, writer);
            StatisticsOperation.writeApplicationStatistics(appStats, writer);
            StatisticsOperation.writeFlowStatistics(appStats, writer);
            writer.write(System.lineSeparator());
        }
    }

    private static void writeApplicationStatistics(AllStatistics appStats, Writer writer) throws IOException {
        FlowConstructStatistics appAppStats = appStats.getApplicationStatistics();
        if (appAppStats != null && appAppStats.isEnabled()) {
            writer.write(String.format("Events Received:             %6d%nEvents Processed:            %6d%nMessages Dispatched:         %6d%nExecution Errors:            %6d%nFatal Errors:                %6d%nConnection Errors:           %6d%nAverage Processing Time:     %6d ms%nMin Processing Time:         %6d ms%nMax Processing Time:         %6d ms%nTotal Processing Time:       %6d ms%n", appAppStats.getTotalEventsReceived(), appAppStats.getProcessedEvents(), appAppStats.getTotalDispatchedMessages(), appAppStats.getExecutionErrors(), appAppStats.getFatalErrors(), appAppStats.getConnectionErrors(), appAppStats.getAverageProcessingTime(), appAppStats.getMinProcessingTime(), appAppStats.getMaxProcessingTime(), appAppStats.getTotalProcessingTime()));
        }
    }

    private static void writeFlowSummaryStatistics(AllStatistics appStats, Writer writer) throws IOException {
        FlowsSummaryStatistics appFlowStats = appStats.getFlowSummaryStatistics();
        if (appFlowStats != null) {
            writer.write(String.format("Private Flows Declared:      %6d%nPrivate Flows Active:        %6d%nTrigger Flows Declared:      %6d%nTrigger Flows Active:        %6d%nAPI Kit Flows Declared:      %6d%nAPI Kit Flows Active:        %6d%n", appFlowStats.getDeclaredPrivateFlows(), appFlowStats.getActivePrivateFlows(), appFlowStats.getDeclaredTriggerFlows(), appFlowStats.getActiveTriggerFlows(), appFlowStats.getDeclaredApikitFlows(), appFlowStats.getActiveApikitFlows()));
        }
    }

    private static void writeFlowStatistics(AllStatistics appStats, Writer writer) throws IOException {
        boolean isFirst = true;
        for (FlowConstructStatistics flowStat : appStats.getServiceStatistics()) {
            if (!flowStat.isEnabled()) continue;
            if (isFirst) {
                writer.write("Flows statistics:" + System.lineSeparator());
                isFirst = false;
            }
            writer.write("  " + flowStat.getName() + ":" + System.lineSeparator());
            writer.write(String.format("    Events Received:         %6d%n    Events Processed:        %6d%n    Messages Dispatched:     %6d%n    Execution Errors:        %6d%n    Fatal Errors:            %6d%n    Connection Errors:       %6d%n    Average Processing Time: %6d ms%n", flowStat.getTotalEventsReceived(), flowStat.getProcessedEvents(), flowStat.getTotalDispatchedMessages(), flowStat.getExecutionErrors(), flowStat.getFatalErrors(), flowStat.getConnectionErrors(), flowStat.getAverageProcessingTime()));
        }
    }

    private static TroubleshootingOperationDefinition createOperationDefinition() {
        return new DefaultTroubleshootingOperationDefinition(STATISTICS_OPERATION_NAME, STATISTICS_OPERATION_DESCRIPTION, StatisticsOperation.createApplicationArgumentDefinition());
    }

    private static ArgumentDefinition createApplicationArgumentDefinition() {
        return new DefaultArgumentDefinition(APPLICATION_ARGUMENT_NAME, APPLICATION_ARGUMENT_DESCRIPTION, false);
    }
}

