/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.service.http.netty.impl.client.RedirectMethodChangeHandler;

public class RedirectMethodChangeHandlerTestCase {
    private static final AttributeKey<Boolean> ALWAYS_SEND_BODY_KEY = AttributeKey.valueOf((String)"ALWAYS_SEND_BODY");
    private static final AttributeKey<Boolean> REDIRECT_CHANGE_METHOD = AttributeKey.valueOf((String)"REDIRECT_CHANGE_METHOD");

    @Test
    public void testNoRedirectMethodNotChanged() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new RedirectMethodChangeHandler()});
        channel.attr(REDIRECT_CHANGE_METHOD).set((Object)Boolean.FALSE);
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/test");
        request.headers().set("Content-Type", (Object)"application/json");
        request.headers().set("Content-Length", (Object)"100");
        channel.writeOutbound(new Object[]{request});
        HttpRequest outboundRequest = (HttpRequest)channel.readOutbound();
        MatcherAssert.assertThat((Object)outboundRequest.method(), (Matcher)Matchers.is((Object)HttpMethod.POST));
        MatcherAssert.assertThat((Object)outboundRequest.headers().contains("Content-Type"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)outboundRequest.headers().contains("Content-Length"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testRedirectMethodChangedToGet() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new RedirectMethodChangeHandler()});
        channel.attr(REDIRECT_CHANGE_METHOD).set((Object)Boolean.TRUE);
        channel.attr(ALWAYS_SEND_BODY_KEY).set((Object)Boolean.FALSE);
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/test");
        request.headers().set("Content-Type", (Object)"application/json");
        request.headers().set("Content-Length", (Object)"100");
        channel.writeOutbound(new Object[]{request});
        HttpRequest outboundRequest = (HttpRequest)channel.readOutbound();
        MatcherAssert.assertThat((Object)outboundRequest.method(), (Matcher)Matchers.is((Object)HttpMethod.GET));
        MatcherAssert.assertThat((Object)outboundRequest.headers().contains("Content-Type"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)outboundRequest.headers().contains("Transfer-Encoding"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)outboundRequest.headers().get("Content-Length"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"0")));
    }

    @Test
    public void testRedirectWithSendBodyAlwaysMethodChangedButBodyNotSuppressed() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new RedirectMethodChangeHandler()});
        channel.attr(REDIRECT_CHANGE_METHOD).set((Object)Boolean.TRUE);
        channel.attr(ALWAYS_SEND_BODY_KEY).set((Object)Boolean.TRUE);
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/test");
        request.headers().set("Content-Type", (Object)"application/json");
        request.headers().set("Content-Length", (Object)"100");
        channel.writeOutbound(new Object[]{request});
        HttpRequest outboundRequest = (HttpRequest)channel.readOutbound();
        MatcherAssert.assertThat((Object)outboundRequest.method(), (Matcher)Matchers.is((Object)HttpMethod.GET));
        MatcherAssert.assertThat((Object)outboundRequest.headers().contains("Content-Type"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)outboundRequest.headers().contains("Content-Length"), (Matcher)Matchers.is((Object)true));
    }
}

