/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.service.http.netty.impl.client.proxy.ProxyAuthenticator;
import org.mule.service.http.netty.impl.message.HttpResponseCreator;
import org.mule.service.http.netty.impl.streaming.BlockingBidirectionalStream;

public class BlindTunnelingProxyClientHandler
extends ProxyHandler {
    private static final String PROTOCOL = "http";
    private static final String AUTH_CUSTOM = "custom";
    private final HttpClientCodec connectCodec = new HttpClientCodec();
    private final ProxyAuthenticator proxyAuthenticator;
    private HttpResponseStatus status;
    private HttpHeaders inboundHeaders;
    private BlockingBidirectionalStream responseStream;
    private OutputStream responseOutput;

    public BlindTunnelingProxyClientHandler(SocketAddress proxyAddress, ProxyAuthenticator proxyAuthenticator) {
        super(proxyAddress);
        this.proxyAuthenticator = proxyAuthenticator;
    }

    public BlindTunnelingProxyClientHandler(ProxyConfig proxyConfig) {
        this(new InetSocketAddress(proxyConfig.getHost(), proxyConfig.getPort()), new ProxyAuthenticator(proxyConfig));
    }

    public String protocol() {
        return PROTOCOL;
    }

    public String authScheme() {
        return this.proxyAuthenticator.getAuthScheme();
    }

    protected void addCodec(ChannelHandlerContext ctx) throws Exception {
        String name = ctx.name();
        ctx.pipeline().addBefore(name, "ConnectMethodsCodec", (ChannelHandler)this.connectCodec);
    }

    protected void removeEncoder(ChannelHandlerContext ctx) throws Exception {
        this.connectCodec.removeOutboundHandler();
    }

    protected void removeDecoder(ChannelHandlerContext ctx) throws Exception {
        this.connectCodec.removeInboundHandler();
    }

    protected Object newInitialMessage(ChannelHandlerContext ctx) throws Exception {
        return this.newConnectRequest((String)null);
    }

    private HttpRequest newConnectRequest(String receivedAuthenticateHeader) throws Exception {
        String firstAuthHeader;
        InetSocketAddress targetAddress = (InetSocketAddress)this.destinationAddress();
        String hostString = HttpUtil.formatHostnameForHttp((InetSocketAddress)targetAddress);
        int port = targetAddress.getPort();
        String url = hostString + ":" + port;
        DefaultHttpHeadersFactory headersFactory = DefaultHttpHeadersFactory.headersFactory().withValidation(false);
        DefaultHttpHeadersFactory trailersFactory = DefaultHttpHeadersFactory.trailersFactory().withValidation(false);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, url, Unpooled.EMPTY_BUFFER, (HttpHeadersFactory)headersFactory, (HttpHeadersFactory)trailersFactory);
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)url);
        if (!this.proxyAuthenticator.hasFinished() && (firstAuthHeader = this.proxyAuthenticator.getNextHeader(receivedAuthenticateHeader)) != null) {
            request.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)firstAuthHeader);
        }
        return request;
    }

    private HttpRequest newConnectRequest(HttpResponse response) throws Exception {
        HttpHeaders fullHeaders = response != null ? response.headers() : null;
        String receivedAuthenticateHeader = fullHeaders != null ? fullHeaders.get((CharSequence)HttpHeaderNames.PROXY_AUTHENTICATE) : null;
        InetSocketAddress targetAddress = (InetSocketAddress)this.destinationAddress();
        String hostString = HttpUtil.formatHostnameForHttp((InetSocketAddress)targetAddress);
        int port = targetAddress.getPort();
        String url = hostString + ":" + port;
        DefaultHttpHeadersFactory headersFactory = DefaultHttpHeadersFactory.headersFactory().withValidation(false);
        DefaultHttpHeadersFactory trailersFactory = DefaultHttpHeadersFactory.trailersFactory().withValidation(false);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, url, Unpooled.EMPTY_BUFFER, (HttpHeadersFactory)headersFactory, (HttpHeadersFactory)trailersFactory);
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)url);
        if (!this.proxyAuthenticator.hasFinished()) {
            String firstAuthHeader;
            String string = firstAuthHeader = AUTH_CUSTOM.equals(this.proxyAuthenticator.getAuthScheme()) ? this.proxyAuthenticator.getNextHeader(this.nettyToMuleResponse(response)) : this.proxyAuthenticator.getNextHeader(receivedAuthenticateHeader);
            if (firstAuthHeader != null) {
                request.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)firstAuthHeader);
            }
        }
        return request;
    }

    protected boolean handleResponse(ChannelHandlerContext ctx, Object obj) throws Exception {
        HttpResponse httpResponse = null;
        if (obj instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)obj;
            if (this.status != null) {
                throw new HttpProxyHandler.HttpProxyConnectException(this.exceptionMessage("too many responses"), null);
            }
            this.status = response.status();
            this.inboundHeaders = response.headers();
            httpResponse = response;
            this.responseStream = new BlockingBidirectionalStream();
            this.responseOutput = this.responseStream.getOutputStream();
        }
        if (obj instanceof HttpContent) {
            ByteBuf contentBuf;
            HttpContent content = (HttpContent)obj;
            if (this.responseOutput != null && (contentBuf = content.content()).isReadable()) {
                try {
                    byte[] bytes = new byte[contentBuf.readableBytes()];
                    contentBuf.getBytes(contentBuf.readerIndex(), bytes);
                    this.responseOutput.write(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to capture response body", e);
                }
            }
        }
        if (obj instanceof LastHttpContent) {
            if (this.status == null || this.inboundHeaders == null) {
                throw new HttpProxyHandler.HttpProxyConnectException(this.exceptionMessage("missing response"), this.inboundHeaders);
            }
            if (this.responseOutput != null) {
                this.responseOutput.close();
                this.responseOutput = null;
            }
            if (this.status.code() == 200) {
                return true;
            }
            if (!this.proxyAuthenticator.hasFinished()) {
                HttpRequest connectRequest = AUTH_CUSTOM.equals(this.proxyAuthenticator.getAuthScheme()) ? this.newConnectRequest(httpResponse) : this.newConnectRequest(this.inboundHeaders.get((CharSequence)HttpHeaderNames.PROXY_AUTHENTICATE));
                this.sendToProxyServer(connectRequest);
                this.status = null;
                this.inboundHeaders = null;
                this.responseStream = null;
                return false;
            }
            throw new HttpProxyHandler.HttpProxyConnectException(this.exceptionMessage("status: " + String.valueOf(this.status)), this.inboundHeaders);
        }
        return false;
    }

    private org.mule.runtime.http.api.domain.message.response.HttpResponse nettyToMuleResponse(HttpResponse response) {
        if (response == null) {
            return null;
        }
        HttpResponseCreator httpResponseCreator = new HttpResponseCreator();
        return httpResponseCreator.create(response, this.responseStream != null ? this.responseStream.getInputStream() : null);
    }
}

