/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseClientConfig;
import org.mule.service.http.common.server.sse.SseResponseStarter;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyHttpRequestAdapter;
import org.mule.service.http.impl.service.server.grizzly.RequestAdapterNotifyingResponseStatusCallback;
import org.mule.service.http.impl.service.server.grizzly.ResponseCompletionHandler;
import org.mule.service.http.impl.service.server.grizzly.ResponseDelayedCompletionHandler;
import org.mule.service.http.impl.service.server.grizzly.ResponseStreamingCompletionHandler;

public class GrizzlyHttpResponseReadyCallback
implements HttpResponseReadyCallback {
    private final GrizzlyHttpRequestAdapter httpRequest;
    private final FilterChainContext ctx;
    private final RequestHandler requestHandler;
    private final HttpRequestPacket request;
    private final ExecutorService workerPool;
    private final AtomicBoolean httpHeaderSent = new AtomicBoolean(false);

    public GrizzlyHttpResponseReadyCallback(GrizzlyHttpRequestAdapter httpRequest, FilterChainContext ctx, RequestHandler requestHandler, HttpRequestPacket request, ExecutorService workerPool) {
        this.httpRequest = httpRequest;
        this.ctx = ctx;
        this.requestHandler = requestHandler;
        this.request = request;
        this.workerPool = workerPool;
    }

    public void responseReady(HttpResponse response, ResponseStatusCallback responseStatusCallback) {
        block7: {
            if (this.httpHeaderSent.compareAndSet(false, true)) {
                try {
                    if (this.httpRequest.getMethod().equals(HttpConstants.Method.HEAD.name())) {
                        if (response.getEntity().isStreaming()) {
                            response.getEntity().getContent().close();
                        }
                        response = ((HttpResponseBuilder)new HttpResponseBuilder(response).entity((HttpEntity)new EmptyHttpEntity())).build();
                    }
                    RequestAdapterNotifyingResponseStatusCallback requestAdapterNotifyingResponseStatusCallback = new RequestAdapterNotifyingResponseStatusCallback(this.httpRequest, responseStatusCallback);
                    if (response.getEntity().isStreaming()) {
                        new ResponseStreamingCompletionHandler(this.ctx, this.requestHandler.getContextClassLoader(), this.request, response, requestAdapterNotifyingResponseStatusCallback, this.workerPool).start();
                        break block7;
                    }
                    new ResponseCompletionHandler(this.ctx, this.requestHandler.getContextClassLoader(), this.request, response, requestAdapterNotifyingResponseStatusCallback).start();
                }
                catch (Exception e) {
                    this.httpHeaderSent.set(false);
                    responseStatusCallback.responseSendFailure((Throwable)e);
                }
            } else {
                throw new IllegalStateException("Response was already initiated for ctx " + this.ctx.toString());
            }
        }
    }

    public Writer startResponse(HttpResponse response, ResponseStatusCallback responseStatusCallback, Charset encoding) {
        if (this.httpHeaderSent.compareAndSet(false, true)) {
            ResponseDelayedCompletionHandler responseCompletionHandler = new ResponseDelayedCompletionHandler(this.ctx, this.requestHandler.getContextClassLoader(), this.request, response, responseStatusCallback);
            return responseCompletionHandler.buildWriter(encoding);
        }
        throw new IllegalStateException("Response was already initiated for ctx " + this.ctx.toString());
    }

    public SseClient startSseResponse(SseClientConfig config) {
        return new SseResponseStarter().startResponse(config, (HttpResponseReadyCallback)this);
    }
}

