/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.io.Serializable;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.queue.Queue;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.internal.util.queue.QueueStore;
import org.mule.runtime.core.internal.util.queue.TransactionContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionAwareQueueStore
implements Queue {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionAwareQueueStore.class);
    private final LifecycleState deploymentLifecycleState;
    private final TransactionContextProvider transactionContextProvider;
    private final QueueStore queue;

    public TransactionAwareQueueStore(QueueStore queue, TransactionContextProvider transactionContextProvider, LifecycleState deploymentLifecycleState) {
        this.queue = queue;
        this.transactionContextProvider = transactionContextProvider;
        this.deploymentLifecycleState = deploymentLifecycleState;
    }

    public void put(Serializable item) throws InterruptedException {
        this.offer(item, Long.MAX_VALUE);
    }

    public void clear() throws InterruptedException {
        if (this.transactionContextProvider.isTransactional()) {
            this.transactionContextProvider.getTransactionalContext().clear(this.queue);
        } else {
            this.queue.clear();
        }
    }

    public boolean offer(Serializable item, long timeout) throws InterruptedException {
        if (this.transactionContextProvider.isTransactional()) {
            return this.transactionContextProvider.getTransactionalContext().offer(this.queue, item, timeout);
        }
        return this.queue.offer(item, 0, timeout);
    }

    public Serializable take() throws InterruptedException {
        return this.poll(Long.MAX_VALUE);
    }

    public void untake(Serializable item) throws InterruptedException {
        if (this.transactionContextProvider.isTransactional()) {
            this.transactionContextProvider.getTransactionalContext().untake(this.queue, item);
        } else {
            this.queue.untake(item);
        }
    }

    public Serializable poll(long timeout) throws InterruptedException {
        try {
            if (this.transactionContextProvider.isTransactional()) {
                Serializable item = this.transactionContextProvider.getTransactionalContext().poll(this.queue, timeout);
                return item;
            }
            return this.queue.poll(timeout);
        }
        catch (InterruptedException iex) {
            if (!this.deploymentLifecycleState.isStopping()) {
                throw iex;
            }
            return null;
        }
    }

    public Serializable peek() throws InterruptedException {
        if (this.transactionContextProvider.isTransactional()) {
            Serializable item = this.transactionContextProvider.getTransactionalContext().peek(this.queue);
            return item;
        }
        return this.queue.peek();
    }

    public void dispose() throws MuleException, InterruptedException {
        this.queue.dispose();
    }

    public int size() {
        if (this.transactionContextProvider.isTransactional()) {
            return this.transactionContextProvider.getTransactionalContext().size(this.queue);
        }
        return this.queue.getSize();
    }

    public String getName() {
        return this.queue.getName();
    }
}

