/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.qameta.allure.Feature;
import java.io.IOException;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpVersion;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.Issue;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;

@Feature(value="HTTP/2 Support")
class Http2SimpleServerTestCase
extends AbstractHttpServerTestCase {
    public static final String H2_PRIOR_ECHO_ENDPOINT = "/h2-prior-echo";

    public Http2SimpleServerTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected String getServerName() {
        return "HTTP/2 Server";
    }

    @Override
    protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder builder) {
        return builder.setHttp1Config(new Http1ProtocolConfig(false)).setHttp2Config(new Http2ProtocolConfig(true));
    }

    @BeforeEach
    void setUp() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler(H2_PRIOR_ECHO_ENDPOINT, (reqCtx, callback) -> {
            HttpRequest req = reqCtx.getRequest();
            String body = this.extractBodyAsString(req);
            String queryParams = req.getQueryParams().toString();
            String uriString = req.getUri().toString();
            StringHttpEntity echoBody = new StringHttpEntity("Request{\n  body: %s,\n  uri: %s,\n  queryParams: %s\n}\n".formatted(body, uriString, queryParams));
            HttpResponse res = ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(200)).entity((HttpEntity)echoBody)).build();
            callback.responseReady(res, (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
        });
    }

    @Test
    @Disabled(value="TODO (W-19814153): Schedule the request handler to IO")
    void echoPostToSimpleHttp2PriorKnowledgeServer() throws Exception {
        try (CloseableHttpAsyncClient h2Client = HttpAsyncClients.createHttp2Default();){
            h2Client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"POST", (String)this.urlForPath(H2_PRIOR_ECHO_ENDPOINT));
            request.setBody("Hello world!", ContentType.TEXT_PLAIN);
            SimpleHttpResponse response = (SimpleHttpResponse)h2Client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_2));
        }
    }

    @Test
    void getToSimpleHttp2PriorKnowledgeServer() throws Exception {
        try (CloseableHttpAsyncClient h2Client = HttpAsyncClients.createHttp2Default();){
            h2Client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath(H2_PRIOR_ECHO_ENDPOINT));
            SimpleHttpResponse response = (SimpleHttpResponse)h2Client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_2));
        }
    }

    @Test
    @Issue(value="W-19802358")
    void getToSimpleHttp2PriorKnowledgeServerWithQueryParams() throws Exception {
        try (CloseableHttpAsyncClient h2Client = HttpAsyncClients.createHttp2Default();){
            h2Client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath("/h2-prior-echo?name1=value1&name2=value2"));
            SimpleHttpResponse response = (SimpleHttpResponse)h2Client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_2));
            MatcherAssert.assertThat((Object)response.getBodyText(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"queryParams: MultiMap{[name1=[value1], name2=[value2]]}"), (Matcher)Matchers.containsString((String)"uri: /h2-prior-echo?name1=value1&name2=value2")));
        }
    }

    private String extractBodyAsString(HttpRequest request) {
        try {
            return new String(request.getEntity().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

