/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.resources;

import com.google.common.base.Joiner;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.extension.privileged.spi.ExtensionsApiSpiUtils;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.boot.ExtensionLoaderUtils;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.capability.xml.schema.ExtensionAnnotationProcessor;
import org.mule.runtime.module.extension.internal.resources.AnnotationProcessorProblemsHandler;
import org.mule.runtime.module.extension.internal.resources.AnnotationProcessorResourceGenerator;
import org.mule.sdk.api.annotation.Extension;

@SupportedAnnotationTypes(value={"org.mule.runtime.extension.api.annotation.Extension"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@SupportedOptions(value={"extension.version", "extension.resources", "extension.classes", "exportedPackagesValidator.skip", "exportedPackagesValidator.strictValidation"})
public abstract class BaseExtensionResourcesGeneratorAnnotationProcessor
extends AbstractProcessor {
    static final ExtensionAnnotationProcessor processor = new ExtensionAnnotationProcessor();
    public static final String PROCESSING_ENVIRONMENT = "PROCESSING_ENVIRONMENT";
    public static final String EXTENSION_ELEMENT = "EXTENSION_ELEMENT";
    public static final String ROUND_ENVIRONMENT = "ROUND_ENVIRONMENT";
    public static final String PROBLEMS_HANDLER = "PROBLEMS_HANDLER";
    public static final String EXTENSION_VERSION = "extension.version";
    public static final String EXTENSION_RESOURCES = "extension.resources";
    public static final String EXTENSION_CLASSES = "extension.classes";
    public static final String EXTENSION_TYPE = "EXTENSION_TYPE";
    private static final String EXTENSION_LOADING_MODE_SYSTEM_PROPERTY = "modelLoader.runtimeMode";
    public static final String COMPILATION_MODE = "COMPILATION_MODE";
    private final LazyValue<ExtensionModelLoader> javaExtensionModelLoader = new LazyValue(() -> ExtensionLoaderUtils.getLoaderById((String)"java"));

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log("Starting Resources generator for Extensions");
        AnnotationProcessorResourceGenerator generator = new AnnotationProcessorResourceGenerator(this.fetchResourceFactories(), this.processingEnv);
        try {
            this.getExtension(roundEnv).ifPresent(extensionElement -> {
                if (!this.shouldProcess((TypeElement)extensionElement, this.processingEnv)) {
                    return;
                }
                ExtensionElement extension = this.toExtensionElement((TypeElement)extensionElement, this.processingEnv);
                String extensionResourcesLocation = this.processingEnv.getOptions().get(EXTENSION_RESOURCES);
                ClassLoader classLoader = extensionResourcesLocation != null ? this.createClassloaderWithExtensionResources(extensionResourcesLocation, processor.getExtensionClassLoader()) : processor.getExtensionClassLoader();
                ClassUtils.withContextClassLoader((ClassLoader)classLoader, () -> {
                    ExtensionModel extensionModel = this.parseExtension((TypeElement)extensionElement, extension, roundEnv, Thread.currentThread().getContextClassLoader());
                    generator.generateFor(extensionModel);
                });
            });
            return false;
        }
        catch (MuleRuntimeException e) {
            IllegalModelDefinitionException exception = (IllegalModelDefinitionException)ExceptionUtils.throwableOfType((Throwable)e, IllegalModelDefinitionException.class);
            if (exception != null) {
                throw exception;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("%s\n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)));
            throw e;
        }
    }

    private ClassLoader createClassloaderWithExtensionResources(String extensionResourcesLocation, ClassLoader parentClassLoader) {
        URLClassLoader classLoaderWithExtensionResources;
        try {
            classLoaderWithExtensionResources = new URLClassLoader(new URL[]{Paths.get(extensionResourcesLocation, new String[0]).toUri().toURL()}, parentClassLoader);
        }
        catch (MalformedURLException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("%s\n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)));
            throw new RuntimeException(e);
        }
        return classLoaderWithExtensionResources;
    }

    protected ExtensionModelLoader fetchJavaExtensionModelLoader() {
        return (ExtensionModelLoader)this.javaExtensionModelLoader.get();
    }

    private ExtensionModel parseExtension(TypeElement extensionElement, ExtensionElement extension, RoundEnvironment roundEnvironment, ClassLoader classLoader) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", extensionElement.toString());
        params.put("version", this.getVersion(extensionElement.getQualifiedName()));
        params.put(EXTENSION_TYPE, extension);
        params.put(EXTENSION_ELEMENT, extensionElement);
        params.put(PROBLEMS_HANDLER, new AnnotationProcessorProblemsHandler(this.processingEnv));
        params.put(PROCESSING_ENVIRONMENT, this.processingEnv);
        params.put(ROUND_ENVIRONMENT, roundEnvironment);
        if (!this.simulateRuntimeLoading()) {
            params.put(COMPILATION_MODE, true);
        }
        ExtensionModelLoadingRequest.Builder builder = ExtensionModelLoadingRequest.builder((ClassLoader)classLoader, (DslResolvingContext)DslResolvingContext.getDefault(Collections.singleton(MuleExtensionModelProvider.getExtensionModel())));
        this.configureLoadingRequest(builder);
        return this.getExtensionModelLoader().loadExtensionModel(builder.addParameters(params).setForceExtensionValidation(true).build());
    }

    private Optional<TypeElement> getExtension(RoundEnvironment env) {
        Set<TypeElement> elements = processor.getTypeElementsAnnotatedWith(org.mule.runtime.extension.api.annotation.Extension.class, env);
        elements.addAll(processor.getTypeElementsAnnotatedWith(Extension.class, env));
        if (elements.size() > 1) {
            String message = String.format("Only one extension is allowed per plugin, however several classes annotated with either @%s or @%s were found. Offending classes are [%s]", org.mule.runtime.extension.api.annotation.Extension.class.getName(), Extension.class.getName(), Joiner.on((String)", ").join((Iterable)elements.stream().map(TypeElement::getQualifiedName).collect(Collectors.toList())));
            throw new RuntimeException(message);
        }
        return elements.stream().findFirst();
    }

    private void log(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }

    private String getVersion(Name qualifiedName) {
        String extensionVersion = this.processingEnv.getOptions().get(EXTENSION_VERSION);
        if (extensionVersion == null) {
            throw new RuntimeException(String.format("Cannot resolve version for extension %s: option '%s' is missing.", qualifiedName, EXTENSION_VERSION));
        }
        return extensionVersion;
    }

    private List<GeneratedResourceFactory> fetchResourceFactories() {
        return Collections.unmodifiableList(Stream.concat(ExtensionsApiSpiUtils.loadGeneratedResourceFactories(), ExtensionsApiSpiUtils.loadDslResourceFactories()).collect(Collectors.toList()));
    }

    private boolean simulateRuntimeLoading() {
        String runtimeMode = System.getProperty(EXTENSION_LOADING_MODE_SYSTEM_PROPERTY);
        return runtimeMode != null && !runtimeMode.trim().isEmpty() ? Boolean.valueOf(runtimeMode) : false;
    }

    public abstract ExtensionElement toExtensionElement(TypeElement var1, ProcessingEnvironment var2);

    protected abstract ExtensionModelLoader getExtensionModelLoader();

    protected void configureLoadingRequest(ExtensionModelLoadingRequest.Builder requestBuilder) {
    }

    protected abstract boolean shouldProcess(TypeElement var1, ProcessingEnvironment var2);
}

