/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.lazy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.ioc.ConfigurableObjectProvider;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.ResourceLocator;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphFactory;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.MuleArtifactContext;
import org.mule.runtime.config.internal.context.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.SpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.context.lazy.ComponentInitializationRequest;
import org.mule.runtime.config.internal.context.lazy.ComponentInitializationState;
import org.mule.runtime.config.internal.context.lazy.LazyComponentInitializerAdapter;
import org.mule.runtime.config.internal.context.lazy.LazySpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.context.lazy.NoSuchComponentModelException;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.model.ComponentModelInitializer;
import org.mule.runtime.config.internal.parsers.generic.AutoIdUtils;
import org.mule.runtime.config.internal.validation.IgnoreOnLazyInit;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.internal.transaction.TransactionManagerFactory;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;

public class LazyMuleArtifactContext
extends MuleArtifactContext
implements LazyComponentInitializerAdapter,
ComponentModelInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyMuleArtifactContext.class);
    private final boolean dslDeclarationValidationEnabled;
    private final Optional<ComponentModelInitializer> parentComponentModelInitializer;
    private final ArtifactAstDependencyGraph postProcessedGraph;
    private final ArtifactAstDependencyGraph baseGraph;
    private final ComponentInitializationState currentComponentInitializationState;
    private final ThreadLocal<Set<String>> beanNamesBeingInitialized = ThreadLocal.withInitial(HashSet::new);
    private final Map<String, String> artifactProperties;

    public LazyMuleArtifactContext(MuleContext muleContext, ArtifactAst artifactAst, Optional<ConfigurationProperties> parentConfigurationProperties, BaseConfigurationComponentLocator baseConfigurationComponentLocator, ContributedErrorTypeRepository errorTypeRepository, ContributedErrorTypeLocator errorTypeLocator, Map<String, String> artifactProperties, ArtifactType artifactType, Optional<ComponentModelInitializer> parentComponentModelInitializer, ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry, MemoryManagementService memoryManagementService, FeatureFlaggingService featureFlaggingService, ExpressionLanguageMetadataService expressionLanguageMetadataService) throws BeansException {
        super(muleContext, artifactAst, parentConfigurationProperties, baseConfigurationComponentLocator, errorTypeRepository, errorTypeLocator, artifactProperties, artifactType, componentBuildingDefinitionRegistry, memoryManagementService, featureFlaggingService, expressionLanguageMetadataService);
        this.componentLocator = new SpringConfigurationComponentLocator();
        this.currentComponentInitializationState = new ComponentInitializationState(this.componentLocator);
        this.parentComponentModelInitializer = parentComponentModelInitializer;
        this.dslDeclarationValidationEnabled = Boolean.valueOf(artifactProperties.getOrDefault("mule.application.deployment.lazyInit.enableDslDeclarationValidations", Boolean.FALSE.toString()));
        this.artifactProperties = artifactProperties;
        this.baseGraph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)this.getApplicationModel());
        this.initialize();
        this.postProcessedGraph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)this.getApplicationModel());
    }

    @Override
    protected SpringMuleContextServiceConfigurator createServiceConfigurator(DefaultListableBeanFactory beanFactory) {
        return new LazySpringMuleContextServiceConfigurator(this, this.artifactProperties, this.getMuleContext(), this.getCoreFunctionsProvider(), (ConfigurationProperties)this.getConfigurationProperties(), this.getArtifactType(), this.getApplicationModel(), (BeanDefinitionRegistry)beanFactory, (Registry)this.getServiceDiscoverer(), (ResourceLocator)this.getResourceLocator(), this.memoryManagementService);
    }

    @Override
    protected void validateArtifact(ArtifactAst artifactAst) {
    }

    @Override
    protected void registerErrors(ArtifactAst artifactAst) {
    }

    @Override
    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        this.currentComponentInitializationState.registerTrackingPostProcessor(beanFactory);
    }

    public Object getBean(String name) throws BeansException {
        return this.tryWithLazyInitializationFallback(name, () -> super.getBean(name));
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return (T)this.tryWithLazyInitializationFallback(name, () -> super.getBean(name, requiredType));
    }

    public boolean containsBean(String name) {
        return this.tryWithLazyInitializationFallback(name, () -> super.containsBean(name));
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.tryWithLazyInitializationFallback(name, () -> super.isSingleton(name));
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return this.tryWithLazyInitializationFallback(name, () -> super.isPrototype(name));
    }

    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        return this.tryWithLazyInitializationFallback(name, () -> super.isTypeMatch(name, typeToMatch));
    }

    public boolean isTypeMatch(String name, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        return this.tryWithLazyInitializationFallback(name, () -> super.isTypeMatch(name, typeToMatch));
    }

    @Nullable
    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return this.tryWithLazyInitializationFallback(name, () -> super.getType(name));
    }

    @Nullable
    public Class<?> getType(String name, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        return this.tryWithLazyInitializationFallback(name, () -> super.getType(name, allowFactoryBeanInit));
    }

    public String[] getAliases(String name) {
        return this.tryWithLazyInitializationFallback(name, () -> super.getAliases(name));
    }

    private <T> T tryWithLazyInitializationFallback(String name, Supplier<T> supplier) {
        try {
            T returnValue = supplier.get();
            if (returnValue == null) {
                return (T)this.initializeAndRetry(name, supplier).getLeft();
            }
            return returnValue;
        }
        catch (NoSuchBeanDefinitionException e) {
            Either<T, Throwable> result = this.initializeAndRetry(name, supplier);
            if (result.isRight()) {
                throw e;
            }
            return (T)result.getLeft();
        }
    }

    private synchronized <T> Either<T, Throwable> initializeAndRetry(String name, Supplier<T> supplier) {
        try {
            T returnValue = supplier.get();
            if (returnValue == null) {
                return this.doInitializeAndRetry(name, supplier);
            }
            return Either.left(returnValue);
        }
        catch (NoSuchBeanDefinitionException e) {
            return this.doInitializeAndRetry(name, supplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Either<T, Throwable> doInitializeAndRetry(String name, Supplier<T> supplier) {
        if (this.beanNamesBeingInitialized.get().contains(name)) {
            throw new IllegalArgumentException(String.format("A cyclic dependency was found when trying to initialize bean '%s'.", name));
        }
        try {
            this.beanNamesBeingInitialized.get().add(name);
            this.initializeAdditionalComponent(componentAst -> componentAst.getComponentId().map(id -> id.equals(name)).orElse(false));
        }
        catch (Exception initializationException) {
            Either either = Either.right((Object)initializationException);
            return either;
        }
        finally {
            this.beanNamesBeingInitialized.get().remove(name);
        }
        return Either.left(supplier.get());
    }

    private void applyLifecycle(List<Object> components, boolean applyStartPhase) {
        this.getMuleContext().withLifecycleLock(() -> {
            if (this.getMuleContext().isInitialised()) {
                this.initializeComponents(components);
            }
            if (this.getMuleContext().isStarted()) {
                if (applyStartPhase) {
                    this.startComponent(components);
                } else {
                    this.startConfigurationProviders(components);
                }
            }
        });
    }

    private void startConfigurationProviders(List<Object> components) {
        components.stream().filter(ConfigurationProvider.class::isInstance).forEach(configurationProviders -> {
            try {
                this.getMuleRegistry().applyLifecycle(configurationProviders, "initialise", "start");
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
    }

    private void initializeComponents(List<Object> components) {
        for (Object object : components) {
            LOGGER.debug("Initializing component '{}'...", object);
            try {
                if (object instanceof MessageProcessorChain) continue;
                this.doInitializeComponent(object);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private void doInitializeComponent(Object component) throws LifecycleException, MuleException {
        try {
            component = this.getMuleContext().getInjector().inject(component);
        }
        catch (MuleException e) {
            throw new LifecycleException((Throwable)e, component);
        }
        this.getMuleRegistry().applyLifecycle(component, "initialise");
    }

    private void startComponent(List<Object> components) {
        for (Object object : components) {
            LOGGER.debug("Starting component '{}'...", object);
            try {
                if (object instanceof MessageProcessorChain) continue;
                this.getMuleRegistry().applyLifecycle(object, "initialise", "start");
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void initializeComponent(Location location) {
        this.initializeComponent(location, true);
    }

    @Override
    public void initializeComponents(LazyComponentInitializer.ComponentLocationFilter filter) {
        this.initializeComponents(filter, true);
    }

    private void initializeAdditionalComponent(Predicate<ComponentAst> componentModelPredicate) {
        Preconditions.checkState((boolean)this.currentComponentInitializationState.isInitializationAlreadyDone(), (String)"initializeComponents must have been called before initializeAdditionalComponent");
        this.createComponentsAndApplyLifecycle(this.getRequestBuilder(this.currentComponentInitializationState.isApplyStartPhaseRequested(), true).build(componentModelPredicate));
    }

    @Override
    public void initializeComponent(Location location, boolean applyStartPhase) {
        this.createComponentsAndApplyLifecycle(this.getRequestBuilder(applyStartPhase, false).build(location));
    }

    @Override
    public void initializeComponents(LazyComponentInitializer.ComponentLocationFilter filter, boolean applyStartPhase) {
        this.createComponentsAndApplyLifecycle(this.getRequestBuilder(applyStartPhase, false).build(filter));
    }

    @Override
    public void initializeComponents(Predicate<ComponentAst> componentModelPredicate, boolean applyStartPhase) {
        this.createComponentsAndApplyLifecycle(this.getRequestBuilder(applyStartPhase, false).build(componentModelPredicate));
    }

    private ComponentInitializationRequest.Builder getRequestBuilder(boolean applyStartPhase, boolean keepPrevious) {
        return new ComponentInitializationRequest.Builder(this.postProcessedGraph, this.baseGraph, this.currentComponentInitializationState, x$0 -> MuleArtifactContext.isAlwaysEnabledComponent(x$0), applyStartPhase, keepPrevious);
    }

    private void createComponentsAndApplyLifecycle(ComponentInitializationRequest initializationRequest) {
        this.applyLifecycle(this.createComponents(initializationRequest, this.getParentComponentModelInitializerAdapter(initializationRequest.isApplyStartPhaseRequested())), initializationRequest.isApplyStartPhaseRequested());
    }

    public Optional<ComponentModelInitializerAdapter> getParentComponentModelInitializerAdapter(boolean applyStartPhase) {
        return this.parentComponentModelInitializer.map(componentModelInitializer -> componentModelPredicate -> componentModelInitializer.initializeComponents(componentModelPredicate, applyStartPhase));
    }

    private void validateModel(ArtifactAst artifactAst) throws ConfigurationException {
        if (this.dslDeclarationValidationEnabled) {
            this.doValidateModel(artifactAst, v -> v.getClass().getAnnotation(IgnoreOnLazyInit.class) == null || v.getClass().getAnnotation(IgnoreOnLazyInit.class).forceDslDeclarationValidation());
        } else {
            this.doValidateModel(artifactAst, v -> v.getClass().getAnnotation(IgnoreOnLazyInit.class) == null);
        }
    }

    private void initializeComponentsFromParent(Optional<ComponentModelInitializerAdapter> parentComponentModelInitializerAdapter) {
        if (parentComponentModelInitializerAdapter.isPresent()) {
            parentComponentModelInitializerAdapter.get().initializeComponents((ComponentAst componentModel) -> this.postProcessedGraph.getMissingDependencies().stream().anyMatch(missingDep -> missingDep.isSatisfiedBy(componentModel)));
        } else {
            this.postProcessedGraph.getMissingDependencies().stream().forEach(missingDep -> {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignoring dependency {} because it does not exist.", missingDep);
                }
            });
        }
    }

    private void validateRequestedComponentExists(Location location, ArtifactAst postProcessedMinimalArtifactAst) {
        if (postProcessedMinimalArtifactAst.recursiveStream().noneMatch(comp -> comp.getLocation() != null && comp.getLocation().getLocation().equals(location.toString()))) {
            throw new NoSuchComponentModelException(I18nMessageFactory.createStaticMessage((String)("No object found at location " + location.toString())));
        }
    }

    private void cleanupAndResetComponentsState() {
        this.unregisterBeans(this.currentComponentInitializationState.getTrackedBeansInOrder());
        this.objectProviders.clear();
        this.resetTransactionFactoryLocator();
        this.resetMuleSecurityManager();
    }

    private void doRegisterErrors(ComponentInitializationRequest initializationRequest) {
        if (this.currentComponentInitializationState.isAllErrorTypesRegistered()) {
            return;
        }
        if (initializationRequest.isKeepPreviousRequested()) {
            this.doRegisterErrors(MuleAstUtils.filteredArtifactAst((ArtifactAst)this.getApplicationModel(), c -> true));
            this.currentComponentInitializationState.setAllErrorTypesRegistered();
        } else {
            this.doRegisterErrors(initializationRequest.getFilteredAstToInitialize());
        }
    }

    private List<Object> createComponents(ComponentInitializationRequest initializationRequest, Optional<ComponentModelInitializerAdapter> parentComponentModelInitializerAdapter) {
        return (List)ClassUtils.withContextClassLoader((ClassLoader)this.getMuleContext().getExecutionClassLoader(), () -> {
            if (this.currentComponentInitializationState.isRequestSatisfied(initializationRequest)) {
                return Collections.emptyList();
            }
            initializationRequest.validateRequestedAst(this::validateModel);
            ArtifactAst minimalAst = initializationRequest.getFilteredAstToInitialize();
            initializationRequest.getLocation().ifPresent(location -> this.validateRequestedComponentExists((Location)location, minimalAst));
            this.initializeComponentsFromParent(parentComponentModelInitializerAdapter);
            if (!initializationRequest.isKeepPreviousRequested()) {
                this.cleanupAndResetComponentsState();
            }
            this.doRegisterErrors(initializationRequest);
            this.currentComponentInitializationState.update(initializationRequest);
            List<Pair<String, ComponentAst>> components = this.createApplicationComponents((DefaultListableBeanFactory)this.getBeanFactory(), minimalAst, false);
            this.prepareObjectProviders(this.currentComponentInitializationState.takeObjectProvidersToConfigure());
            LOGGER.debug("Will create beans: {}", components);
            return this.createBeans(components);
        });
    }

    @Override
    protected List<Pair<String, ComponentAst>> doCreateApplicationComponents(DefaultListableBeanFactory beanFactory, ArtifactAst minimalAppModel, boolean mustBeRoot, Map<ComponentAst, SpringComponentModel> springComponentModels) {
        List<Pair<String, ComponentAst>> applicationComponents = super.doCreateApplicationComponents(beanFactory, minimalAppModel, mustBeRoot, springComponentModels);
        Set orphanComponents = MuleAstUtils.resolveOrphanComponents((ArtifactAst)minimalAppModel);
        LOGGER.debug("orphanComponents found: {}", (Object)orphanComponents);
        orphanComponents.stream().filter(cm -> Arrays.asList(TypedComponentIdentifier.ComponentType.SOURCE, TypedComponentIdentifier.ComponentType.OPERATION, TypedComponentIdentifier.ComponentType.SCOPE, TypedComponentIdentifier.ComponentType.SUB_FLOW).contains(cm.getComponentType())).filter(cm -> cm.getComponentId().isPresent()).forEach(cm -> {
            String nameAttribute = (String)cm.getComponentId().get();
            LOGGER.debug("Registering orphan named component '{}'...", (Object)nameAttribute);
            applicationComponents.add(0, new Pair((Object)nameAttribute, cm));
            SpringComponentModel springCompModel = (SpringComponentModel)springComponentModels.get(cm);
            BeanDefinition beanDef = springCompModel.getBeanDefinition();
            if (beanDef != null) {
                beanFactory.registerBeanDefinition((String)cm.getComponentId().get(), beanDef);
                LazyMuleArtifactContext.postProcessBeanDefinition(springCompModel, (BeanDefinitionRegistry)beanFactory, (String)cm.getComponentId().get());
            }
        });
        orphanComponents.stream().filter(cm -> !this.isIgnored((ComponentAst)cm)).forEach(cm -> {
            SpringComponentModel springCompModel = (SpringComponentModel)springComponentModels.get(cm);
            BeanDefinition beanDef = springCompModel.getBeanDefinition();
            if (beanDef != null) {
                String beanName = cm.getComponentId().orElse(AutoIdUtils.uniqueValue(beanDef.getBeanClassName()));
                LOGGER.debug("Registering orphan un-named component '{}'...", (Object)beanName);
                applicationComponents.add(new Pair((Object)beanName, cm));
                beanFactory.registerBeanDefinition(beanName, beanDef);
                LazyMuleArtifactContext.postProcessBeanDefinition(springCompModel, (BeanDefinitionRegistry)beanFactory, beanName);
            }
        });
        LOGGER.debug("applicationComponents to be created: {}", applicationComponents);
        return applicationComponents;
    }

    private List<Object> createBeans(List<Pair<String, ComponentAst>> applicationComponentNames) {
        this.currentComponentInitializationState.startTrackingBeans();
        LinkedHashMap objects = new LinkedHashMap();
        applicationComponentNames.forEach(componentPair -> {
            try {
                Object object = this.getRegistry().lookupByName((String)componentPair.getFirst()).orElse(null);
                if (object != null) {
                    if (object instanceof MessageProcessorChainBuilder) {
                        MessageProcessorChainBuilder mpcb = (MessageProcessorChainBuilder)object;
                        this.handleChainBuilder(mpcb, (Pair<String, ComponentAst>)componentPair, objects);
                    } else if (object instanceof TransactionManagerFactory) {
                        TransactionManagerFactory txMgrFy = (TransactionManagerFactory)object;
                        this.handleTxManagerFactory(txMgrFy);
                    }
                    objects.put(componentPair, object);
                }
            }
            catch (Exception e) {
                this.currentComponentInitializationState.commitTrackedBeansContainedIn(objects.keySet().stream().map(Pair::getFirst).toList());
                this.safeUnregisterBean((String)componentPair.getFirst());
                throw new MuleRuntimeException((Throwable)e);
            }
        });
        HashMap componentNames = new HashMap();
        objects.entrySet().forEach(entry -> {
            Object object = entry.getValue();
            Pair component = (Pair)entry.getKey();
            componentNames.put(object, component);
        });
        this.currentComponentInitializationState.commitTrackedBeansContainedIn(objects.keySet().stream().map(Pair::getFirst).toList());
        ArrayList<Object> sortedObjects = new ArrayList<Object>(objects.values());
        Collections.sort(sortedObjects, (o1, o2) -> this.postProcessedGraph.dependencyComparator().compare((ComponentAst)((Pair)componentNames.get(o1)).getSecond(), (ComponentAst)((Pair)componentNames.get(o2)).getSecond()));
        return sortedObjects;
    }

    private void handleChainBuilder(MessageProcessorChainBuilder object, Pair<String, ComponentAst> componentPair, Map<Pair<String, ComponentAst>, Object> objects) {
        Pair chainKey = new Pair((Object)((String)componentPair.getFirst() + "@" + object.hashCode()), (Object)((ComponentAst)componentPair.getSecond()));
        MessageProcessorChain messageProcessorChain = object.build();
        try {
            LifecycleUtils.initialiseIfNeeded((Object)messageProcessorChain, (MuleContext)this.getMuleContext());
        }
        catch (InitialisationException e) {
            this.unregisterBeans(objects.keySet().stream().map(Pair::getFirst).toList());
            throw new IllegalStateException("Couldn't initialise an instance of a MessageProcessorChain", e);
        }
        try {
            this.getMuleRegistry().registerObject((String)chainKey.getFirst(), (Object)messageProcessorChain);
        }
        catch (RegistrationException e) {
            this.unregisterBeans(objects.keySet().stream().map(Pair::getFirst).toList());
            throw new IllegalStateException("Couldn't register an instance of a MessageProcessorChain", e);
        }
        objects.put((Pair<String, ComponentAst>)chainKey, messageProcessorChain);
    }

    private void handleTxManagerFactory(TransactionManagerFactory object) {
        try {
            LegacyRegistryUtils.registerObject((MuleContext)this.getMuleContext(), (String)"_muleTransactionManager", (Object)object.create(this.getMuleContext().getConfiguration()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't register an instance of a TransactionManager", e);
        }
    }

    private void resetTransactionFactoryLocator() {
        TransactionFactoryLocator transactionFactoryLocator;
        try {
            transactionFactoryLocator = (TransactionFactoryLocator)this.getMuleRegistry().lookupObject(TransactionFactoryLocator.class);
        }
        catch (RegistrationException e) {
            LOGGER.warn("No TransactionFactoryLocator in registry, skipping its reset...");
            return;
        }
        if (transactionFactoryLocator != null) {
            transactionFactoryLocator.dispose();
        }
    }

    private void resetMuleSecurityManager() {
        SecurityManager securityManager = (SecurityManager)this.getMuleRegistry().get("_muleSecurityManager");
        if (securityManager != null) {
            securityManager.getProviders().forEach(p -> securityManager.removeProvider(p.getName()));
            securityManager.getEncryptionStrategies().forEach(s -> securityManager.removeEncryptionStrategy(s.getName()));
        }
    }

    @Override
    protected void onObjectProviderDiscovered(ConfigurableObjectProvider objectProvider) {
        super.onObjectProviderDiscovered(objectProvider);
        this.currentComponentInitializationState.registerObjectProviderToConfigure(objectProvider);
    }

    @Override
    public void close() {
        this.beanNamesBeingInitialized.remove();
        this.currentComponentInitializationState.clear();
        super.close();
    }

    private void unregisterBeans(List<String> beans) {
        this.doUnregisterBeans(new LinkedList<String>(beans).descendingIterator());
        this.componentLocator.removeComponents();
    }

    private void doUnregisterBeans(Iterator<String> beanNames) {
        while (beanNames.hasNext()) {
            String beanName = beanNames.next();
            try {
                LegacyRegistryUtils.unregisterObject((MuleContext)this.getMuleContext(), (String)beanName);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Exception unregistering an object during lazy initialization of component %s, exception message is %s", beanName, e.getMessage()));
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"There was an error while unregistering component '%s'", (Object[])new Object[]{beanName}), (Throwable)e);
            }
        }
    }

    private void safeUnregisterBean(String beanName) {
        try {
            LegacyRegistryUtils.unregisterObject((MuleContext)this.getMuleContext(), (String)beanName);
        }
        catch (RegistrationException registrationException) {
            // empty catch block
        }
    }

    @Override
    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        this.getApplicationModel().filteredComponents(cm -> !this.isIgnored((ComponentAst)cm)).forEach(cm -> this.componentLocator.addComponentLocation(cm.getLocation()));
    }

    @FunctionalInterface
    private static interface ComponentModelInitializerAdapter {
        public void initializeComponents(Predicate<ComponentAst> var1);
    }
}

