/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.api.service.discoverer;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.discoverer.DefaultServiceDiscoverer;

public class OverridingServiceDiscoverer
implements ServiceDiscoverer {
    private final Map<String, Service> overridesMap;
    private final ServiceDiscoverer delegate;

    public OverridingServiceDiscoverer(ServiceProviderDiscoverer serviceProviderDiscoverer, List<Service> overrides) {
        this.overridesMap = overrides.stream().collect(Collectors.toMap(NamedObject::getName, Function.identity()));
        this.delegate = new DefaultServiceDiscoverer(serviceProviderDiscoverer){

            protected List<ServiceAssembly> discoverAssemblies() throws ServiceResolutionError {
                return super.discoverAssemblies().stream().filter(assembly -> !OverridingServiceDiscoverer.this.overridesMap.containsKey(assembly.getName())).collect(Collectors.toList());
            }
        };
    }

    public List<Service> discoverServices() throws ServiceResolutionError {
        LinkedList<Service> services = new LinkedList<Service>(this.delegate.discoverServices());
        services.addAll(this.overridesMap.values());
        return services;
    }
}

