/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.netty.impl.server.ConditionalRequestAggregator;
import org.mule.service.http.netty.impl.server.ConnectionsCounterHandler;
import org.mule.service.http.netty.impl.server.ForwardingToListenerHandler;
import org.mule.service.http.netty.impl.server.ForwardingToListenerInitializer;
import org.mule.service.http.netty.impl.server.Http2ConnectionCleanupHandler;
import org.mule.service.http.netty.impl.server.HttpWithAPNServerHandler;
import org.mule.service.http.netty.impl.server.KeepAliveHandler;
import org.mule.service.http.netty.impl.server.MuleHttpServerExpectContinueHandler;
import org.mule.service.http.netty.impl.server.MultiplexerChannelInitializer;
import org.mule.service.http.netty.impl.server.UpgradeToHttp2CleartextCodecFactory;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.impl.util.HttpLoggingHandler;

public class AcceptedConnectionChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY = "mule.http.headerSectionSize";
    public static final String FLUSH_CONSOLIDATION_HANDLER_NAME = "flushConsolidationHandler";
    private final SslContext sslContext;
    private final HttpListenerRegistry httpListenerRegistry;
    private final String serverName;
    private final boolean usePersistentConnections;
    private final long connectionIdleTimeout;
    private final long readTimeout;
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private final ConnectionsCounterHandler connectionsCountHandler;
    private final ExecutorService ioExecutor;
    private final Http1ProtocolConfig http1Config;
    private final Http2ProtocolConfig http2Config;

    public AcceptedConnectionChannelInitializer(HttpListenerRegistry httpListenerRegistry, HttpServerConfiguration configuration, SslContext sslContext, ExecutorService ioExecutor) {
        this(httpListenerRegistry, configuration.getName(), configuration.isUsePersistentConnections(), configuration.getConnectionIdleTimeout(), configuration.getReadTimeout(), sslContext, ioExecutor, configuration.getHttp1Config(), configuration.getHttp2Config());
    }

    public AcceptedConnectionChannelInitializer(HttpListenerRegistry httpListenerRegistry, String serverName, boolean usePersistentConnections, int connectionIdleTimeout, long readTimeout, SslContext sslContext, ExecutorService ioExecutor) {
        this(httpListenerRegistry, serverName, usePersistentConnections, connectionIdleTimeout, readTimeout, sslContext, AcceptedConnectionChannelInitializer.retrieveMaximumHeaderSectionSize(), ioExecutor, new Http1ProtocolConfig(true), new Http2ProtocolConfig(true));
    }

    public AcceptedConnectionChannelInitializer(HttpListenerRegistry httpListenerRegistry, String serverName, boolean usePersistentConnections, int connectionIdleTimeout, long readTimeout, SslContext sslContext, ExecutorService ioExecutor, Http1ProtocolConfig http1Config, Http2ProtocolConfig http2Config) {
        this(httpListenerRegistry, serverName, usePersistentConnections, connectionIdleTimeout, readTimeout, sslContext, AcceptedConnectionChannelInitializer.retrieveMaximumHeaderSectionSize(), ioExecutor, http1Config, http2Config);
    }

    public AcceptedConnectionChannelInitializer(HttpListenerRegistry httpListenerRegistry, String serverName, boolean usePersistentConnections, int connectionIdleTimeout, long readTimeout, SslContext sslContext, int maxHeaderSectionSize, ExecutorService ioExecutor) {
        this(httpListenerRegistry, serverName, usePersistentConnections, connectionIdleTimeout, readTimeout, sslContext, maxHeaderSectionSize, ioExecutor, new Http1ProtocolConfig(true), new Http2ProtocolConfig(true));
    }

    public AcceptedConnectionChannelInitializer(HttpListenerRegistry httpListenerRegistry, String serverName, boolean usePersistentConnections, int connectionIdleTimeout, long readTimeout, SslContext sslContext, int maxHeaderSectionSize, ExecutorService ioExecutor, Http1ProtocolConfig http1Config, Http2ProtocolConfig http2Config) {
        this.httpListenerRegistry = httpListenerRegistry;
        this.serverName = serverName;
        this.usePersistentConnections = usePersistentConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.readTimeout = readTimeout;
        this.sslContext = sslContext;
        this.maxInitialLineLength = maxHeaderSectionSize;
        this.maxHeaderSize = maxHeaderSectionSize;
        this.connectionsCountHandler = new ConnectionsCounterHandler();
        this.ioExecutor = ioExecutor;
        this.http1Config = http1Config;
        this.http2Config = http2Config;
    }

    protected void initChannel(SocketChannel socketChannel) {
        socketChannel.pipeline().addFirst(FLUSH_CONSOLIDATION_HANDLER_NAME, (ChannelHandler)new FlushConsolidationHandler(256, true));
        socketChannel.pipeline().addFirst(new ChannelHandler[]{this.connectionsCountHandler});
        this.configureTimeouts(socketChannel);
        if (null != this.sslContext) {
            this.configureWithSslAndALPN((Channel)socketChannel);
            return;
        }
        if (!this.http1Config.isEnabled() && !this.http2Config.isEnabled()) {
            throw new IllegalStateException("Both HTTP/1 and HTTP/2 protocols are disabled");
        }
        if (this.http1Config.isEnabled() && this.http2Config.isEnabled()) {
            this.configureHttp2CleartextWithFallbackToHttp1(socketChannel);
            return;
        }
        if (this.http2Config.isEnabled()) {
            this.configureHttp2(socketChannel.pipeline(), null);
            return;
        }
        this.configureHttp1(socketChannel.pipeline(), null);
    }

    private void configureHttp2CleartextWithFallbackToHttp1(SocketChannel socketChannel) {
        socketChannel.pipeline().addLast("HTTP/2 Logging Handler", (ChannelHandler)HttpLoggingHandler.hexDump(this.serverName));
        socketChannel.pipeline().addLast("Cleartext HTTP/2 Server Upgrade Handler", (ChannelHandler)this.createHttp2CleartextUpgradeHandler());
        this.configureHttp1PostCodec(socketChannel.pipeline(), null);
    }

    private void configureHttp1PostCodec(ChannelPipeline pipeline, SslHandler sslHandler) {
        pipeline.addLast("Expect Continue Handler", (ChannelHandler)new MuleHttpServerExpectContinueHandler());
        pipeline.addLast("Keep Alive", (ChannelHandler)new KeepAliveHandler(this.usePersistentConnections));
        pipeline.addLast("Forward Initializer", (ChannelHandler)new ForwardingToListenerInitializer(this.httpListenerRegistry, sslHandler, this.ioExecutor));
    }

    private CleartextHttp2ServerUpgradeHandler createHttp2CleartextUpgradeHandler() {
        HttpServerCodec sourceCodec = new HttpServerCodec(this.maxInitialLineLength, this.maxHeaderSize, 8192);
        UpgradeToHttp2CleartextCodecFactory upgradeCodecFactory = new UpgradeToHttp2CleartextCodecFactory(this.httpListenerRegistry, this.ioExecutor);
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, (HttpServerUpgradeHandler.UpgradeCodecFactory)upgradeCodecFactory);
        return new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, (ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().remove(MuleHttpServerExpectContinueHandler.class);
                ch.pipeline().remove(KeepAliveHandler.class);
                ch.pipeline().remove(ConditionalRequestAggregator.class);
                ch.pipeline().remove(ForwardingToListenerHandler.class);
                AcceptedConnectionChannelInitializer.this.configureHttp2(ch.pipeline(), null);
            }
        });
    }

    public boolean waitForConnectionsToBeClosed(Long timeout, TimeUnit timeUnit) {
        return this.connectionsCountHandler.waitForConnectionsToBeClosed(timeout, timeUnit);
    }

    private void configureWithSslAndALPN(Channel channel) {
        SslHandler sslHandler = this.sslContext.newHandler(channel.alloc());
        channel.pipeline().addLast("SSL Handler", (ChannelHandler)sslHandler).addLast("Protocol Negotiation Handler", (ChannelHandler)new HttpWithAPNServerHandler(this::configureHttp1, this::configureHttp2, sslHandler, this.apnFallback()));
    }

    private String apnFallback() {
        return this.http1Config.isEnabled() ? "http/1.1" : "h2";
    }

    private void configureTimeouts(SocketChannel socketChannel) {
        if (this.connectionIdleTimeout != -1L || this.readTimeout != -1L) {
            socketChannel.pipeline().addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(this.readTimeout, this.connectionIdleTimeout, this.connectionIdleTimeout, TimeUnit.MILLISECONDS));
        }
    }

    protected void configureHttp1(ChannelPipeline pipeline, SslHandler sslHandler) {
        pipeline.addLast("Logging Handler", (ChannelHandler)HttpLoggingHandler.textual(this.serverName));
        pipeline.addLast("HTTP/1 Codec", (ChannelHandler)new HttpServerCodec(this.maxInitialLineLength, this.maxHeaderSize, 8192));
        this.configureHttp1PostCodec(pipeline, sslHandler);
    }

    protected void configureHttp2(ChannelPipeline pipeline, SslHandler sslHandler) {
        pipeline.addLast("Logging Handler", (ChannelHandler)HttpLoggingHandler.hexDump(this.serverName));
        Http2Settings http2Settings = Http2Settings.defaultSettings();
        this.http2Config.getHeaderTableSize().ifPresent(arg_0 -> ((Http2Settings)http2Settings).headerTableSize(arg_0));
        this.http2Config.getMaxConcurrentStreams().ifPresent(arg_0 -> ((Http2Settings)http2Settings).maxConcurrentStreams(arg_0));
        this.http2Config.getInitialWindowSize().ifPresent(arg_0 -> ((Http2Settings)http2Settings).initialWindowSize(arg_0));
        this.http2Config.getMaxFrameSize().ifPresent(arg_0 -> ((Http2Settings)http2Settings).maxFrameSize(arg_0));
        this.http2Config.getMaxHeaderListSize().ifPresent(arg_0 -> ((Http2Settings)http2Settings).maxHeaderListSize(arg_0));
        Http2FrameCodec frameCodec = Http2FrameCodecBuilder.forServer().initialSettings(http2Settings).build();
        pipeline.addLast("HTTP/2 Codec", (ChannelHandler)frameCodec);
        pipeline.addLast("Connection Cleanup", (ChannelHandler)new Http2ConnectionCleanupHandler((Http2ConnectionHandler)frameCodec));
        pipeline.addLast("Multiplexer", (ChannelHandler)new Http2MultiplexHandler((ChannelHandler)new MultiplexerChannelInitializer(this.httpListenerRegistry, sslHandler, this.ioExecutor)));
    }

    private static int retrieveMaximumHeaderSectionSize() {
        try {
            return Integer.parseInt(System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY, String.valueOf(8192)));
        }
        catch (NumberFormatException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid value %s for %s configuration", System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY), MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY)), (Throwable)e);
        }
    }
}

