/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json;

import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerFormat;
import org.mule.runtime.ast.internal.serialization.json.JsonArtifactAstDeserializer;
import org.mule.runtime.ast.internal.serialization.json.JsonArtifactAstSerializer;

public class JsonArtifactAstSerializerFormat
implements ArtifactAstSerializerFormat {
    public static final String JSON = "JSON";
    public static final String V_1_0 = "1.0";
    public static final String V_1_1 = "1.1";
    private static final List<String> VERSIONS = Collections.unmodifiableList(Arrays.asList("1.0", "1.1"));

    @Override
    public String getId() {
        return JSON;
    }

    @Override
    public JsonArtifactAstSerializer createSerializer(String version, Executor executor) {
        return new JsonArtifactAstSerializer(executor, version);
    }

    @Override
    public JsonArtifactAstDeserializer createDeserializer(String version, boolean populateGenerationInformation) {
        return new JsonArtifactAstDeserializer(new GsonBuilder().setStrictness(Strictness.STRICT), version, populateGenerationInformation);
    }

    @Override
    public List<String> getAvailableVersions() {
        return VERSIONS;
    }

    @Override
    public String getLatestVersion() {
        return VERSIONS.get(VERSIONS.size() - 1);
    }
}

