/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.objectpool;

import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.ArgumentValidation;
import org.vibur.objectpool.util.ConcurrentCollection;
import org.vibur.objectpool.util.Listener;

public class ConcurrentPool<T>
implements PoolService<T> {
    private static final int RESERVED = 4096;
    private static final int MAX_ALLOWED_SIZE = 0x7FFFEFFF;
    private final ConcurrentCollection<T> available;
    private final Semaphore takeSemaphore;
    private final PoolObjectFactory<T> poolObjectFactory;
    private final Listener<T> listener;
    private final int initialSize;
    private final int maxSize;
    private final AtomicInteger createdTotal;
    private final AtomicBoolean terminated = new AtomicBoolean(false);

    public ConcurrentPool(ConcurrentCollection<T> available, PoolObjectFactory<T> poolObjectFactory, int initialSize, int maxSize, boolean fair) {
        this(available, poolObjectFactory, initialSize, maxSize, fair, null);
    }

    public ConcurrentPool(ConcurrentCollection<T> available, PoolObjectFactory<T> poolObjectFactory, int initialSize, int maxSize, boolean fair, Listener<T> listener) {
        ArgumentValidation.forbidIllegalArgument(initialSize < 0, "initialSize");
        ArgumentValidation.forbidIllegalArgument(maxSize < 1 || maxSize < initialSize || maxSize > 0x7FFFEFFF, "maxSize");
        int availableSize = available.size();
        ArgumentValidation.forbidIllegalArgument(availableSize != 0 && availableSize != initialSize, "available");
        this.available = available;
        this.poolObjectFactory = Objects.requireNonNull(poolObjectFactory);
        this.listener = listener;
        this.initialSize = initialSize;
        this.maxSize = maxSize;
        this.takeSemaphore = new Semaphore(maxSize, fair);
        this.createdTotal = new AtomicInteger(availableSize);
        if (availableSize == 0) {
            this.addInitialObjects();
        }
    }

    private void addInitialObjects() {
        try {
            for (int i = 0; i < this.initialSize; ++i) {
                this.available.offerLast(Objects.requireNonNull(this.poolObjectFactory.create()));
                this.createdTotal.incrementAndGet();
            }
        }
        catch (Throwable t) {
            this.drainCreated();
            throw t;
        }
    }

    @Override
    public T take() {
        try {
            this.takeSemaphore.acquire();
            return this.takeObject();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T take(long[] waitedNanos) {
        try {
            long startTime = System.nanoTime();
            try {
                this.takeSemaphore.acquire();
            }
            finally {
                waitedNanos[0] = System.nanoTime() - startTime;
            }
            return this.takeObject();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public T takeUninterruptibly() {
        this.takeSemaphore.acquireUninterruptibly();
        return this.takeObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T takeUninterruptibly(long[] waitedNanos) {
        long startTime = System.nanoTime();
        try {
            this.takeSemaphore.acquireUninterruptibly();
        }
        finally {
            waitedNanos[0] = System.nanoTime() - startTime;
        }
        return this.takeObject();
    }

    @Override
    public T tryTake(long timeout, TimeUnit unit) {
        try {
            if (!this.takeSemaphore.tryAcquire(timeout, unit)) {
                return null;
            }
            return this.takeObject();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T tryTake(long timeout, TimeUnit unit, long[] waitedNanos) {
        try {
            long startTime = System.nanoTime();
            try {
                if (this.takeSemaphore.tryAcquire(timeout, unit)) return this.takeObject();
                T t = null;
                return t;
            }
            finally {
                waitedNanos[0] = System.nanoTime() - startTime;
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public T tryTake() {
        if (!this.takeSemaphore.tryAcquire()) {
            return null;
        }
        return this.takeObject();
    }

    private T takeObject() {
        T object = this.prepareToTake(this.available.pollFirst());
        if (this.listener != null) {
            this.listener.onTake(object);
        }
        if (this.isTerminated()) {
            this.restore(object, false);
            return null;
        }
        return object;
    }

    @Override
    public void restore(T object) {
        this.restore(object, true);
    }

    @Override
    public void restore(T object, boolean valid) {
        boolean ready = this.readyToRestore(Objects.requireNonNull(object), valid);
        if (this.listener != null) {
            this.listener.onRestore(object, valid);
        }
        if (ready) {
            this.available.offerFirst(object);
        }
        this.takeSemaphore.release();
        if (this.isTerminated() && valid) {
            this.terminate();
        }
    }

    private T prepareToTake(T object) {
        try {
            if (object == null) {
                this.createdTotal.incrementAndGet();
                object = Objects.requireNonNull(this.poolObjectFactory.create());
            } else {
                boolean ready = false;
                try {
                    ready = this.poolObjectFactory.readyToTake(object);
                }
                finally {
                    if (!ready) {
                        this.poolObjectFactory.destroy(object);
                    }
                }
                if (!ready) {
                    object = Objects.requireNonNull(this.poolObjectFactory.create());
                }
            }
            return object;
        }
        catch (Throwable t) {
            this.recoverInnerState();
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readyToRestore(T object, boolean valid) {
        try {
            boolean ready = false;
            try {
                ready = valid && this.poolObjectFactory.readyToRestore(object);
            }
            finally {
                if (!ready) {
                    this.poolObjectFactory.destroy(object);
                }
            }
            if (!ready) {
                this.createdTotal.decrementAndGet();
            }
            return ready;
        }
        catch (Throwable t) {
            this.recoverInnerState();
            throw t;
        }
    }

    private void recoverInnerState() {
        this.createdTotal.decrementAndGet();
        this.takeSemaphore.release();
    }

    @Override
    public Listener<T> listener() {
        return this.listener;
    }

    @Override
    public int taken() {
        return !this.isTerminated() ? this.calculateTaken() : this.createdTotal();
    }

    private int calculateTaken() {
        return this.maxSize() - this.remainingCapacity();
    }

    @Override
    public int remainingCreated() {
        return !this.isTerminated() ? this.createdTotal() - this.calculateTaken() : 0;
    }

    @Override
    public int drainCreated() {
        return this.reduceCreatedTo(0, true);
    }

    public String toString() {
        return super.toString() + (String)(!this.isTerminated() ? "[remainingCreated = " + this.remainingCreated() + "]" : "[terminated]");
    }

    @Override
    public int createdTotal() {
        return this.createdTotal.get();
    }

    @Override
    public int remainingCapacity() {
        return !this.isTerminated() ? this.takeSemaphore.availablePermits() : 0;
    }

    @Override
    public int initialSize() {
        return this.initialSize;
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public int reduceCreatedBy(int reduceBy, boolean ignoreInitialSize) {
        ArgumentValidation.forbidIllegalArgument(reduceBy < 0, "reduceBy");
        for (int cnt = 0; cnt < reduceBy; ++cnt) {
            if (this.reduceByOne(ignoreInitialSize)) continue;
            return cnt;
        }
        return reduceBy;
    }

    @Override
    public int reduceCreatedTo(int reduceTo, boolean ignoreInitialSize) {
        ArgumentValidation.forbidIllegalArgument(reduceTo < 0, "reduceTo");
        int cnt = 0;
        while (this.createdTotal() > reduceTo && this.reduceByOne(ignoreInitialSize)) {
            ++cnt;
        }
        return cnt;
    }

    private boolean reduceByOne(boolean ignoreInitialSize) {
        int newTotal = this.createdTotal.decrementAndGet();
        if (!ignoreInitialSize && newTotal < this.initialSize) {
            this.createdTotal.incrementAndGet();
            return false;
        }
        T object = this.available.pollLast();
        if (object == null) {
            this.createdTotal.incrementAndGet();
            return false;
        }
        this.poolObjectFactory.destroy(object);
        return true;
    }

    @Override
    public void terminate() {
        boolean wasTerminated = this.terminated.getAndSet(true);
        this.drainCreated();
        if (!wasTerminated) {
            this.takeSemaphore.release(this.takeSemaphore.getQueueLength() + 4096);
        }
    }

    @Override
    public void close() {
        this.terminate();
    }

    @Override
    public boolean isTerminated() {
        return this.terminated.get();
    }

    @Override
    public boolean isFair() {
        return this.takeSemaphore.isFair();
    }
}

