/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.connectionpool;

import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectorHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.connectionpool.Endpoint;

public class EndpointKey<E>
extends Endpoint<E> {
    private final Object internalKey;
    private final E targetEndpointAddress;
    private final E localEndpointAddress;
    private final ConnectorHandler<E> connectorHandler;

    public EndpointKey(Object internalKey, E endpointAddress) {
        this(internalKey, endpointAddress, null, (ConnectorHandler<Object>)null);
    }

    public EndpointKey(Object internalKey, E endpointAddress, E localEndpointAddress) {
        this(internalKey, endpointAddress, localEndpointAddress, null);
    }

    public EndpointKey(Object internalKey, E endpointAddress, ConnectorHandler<E> connectorHandler) {
        this(internalKey, endpointAddress, null, (ConnectorHandler<Object>)connectorHandler);
    }

    public EndpointKey(Object internalKey, E endpointAddress, E localEndpointAddress, ConnectorHandler<E> connectorHandler) {
        if (internalKey == null) {
            throw new NullPointerException("internal key can't be null");
        }
        if (endpointAddress == null) {
            throw new NullPointerException("target endpoint address can't be null");
        }
        this.internalKey = internalKey;
        this.targetEndpointAddress = endpointAddress;
        this.localEndpointAddress = localEndpointAddress;
        this.connectorHandler = connectorHandler;
    }

    @Override
    public GrizzlyFuture<Connection> connect() {
        return (GrizzlyFuture)this.connectorHandler.connect(this.targetEndpointAddress, this.localEndpointAddress);
    }

    @Override
    public Object getId() {
        return this.getInternalKey();
    }

    public Object getInternalKey() {
        return this.internalKey;
    }

    public E getEndpoint() {
        return this.targetEndpointAddress;
    }

    public E getLocalEndpoint() {
        return this.localEndpointAddress;
    }

    public ConnectorHandler<E> getConnectorHandler() {
        return this.connectorHandler;
    }

    public String toString() {
        return "EndpointKey{internalKey=" + this.internalKey + ", targetEndpointAddress=" + this.targetEndpointAddress + ", localEndpointAddress=" + this.localEndpointAddress + ", connectorHandler=" + this.connectorHandler + "} " + super.toString();
    }

    @Override
    public GrizzlyFuture<Connection> connect(CompletionHandler<Connection> completionHandler) {
        return (GrizzlyFuture)this.connectorHandler.connect(this.targetEndpointAddress, this.localEndpointAddress, completionHandler);
    }
}

