/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server.sse;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseClientConfig;
import org.mule.service.http.common.server.sse.SseResponseStarter;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.common.util.HttpMessageHeaderMatcher;

@Feature(value="Server Sent Events (SSE)")
@Story(value="SSE Endpoint")
public class SseResponseStarterTestCase
extends AbstractHttpTestCase {
    private static final String SSE_CONTENT_TYPE = "text/event-stream";
    private StringWriter serializedDataSink;
    private HttpResponseReadyCallback callback;
    private SseClientConfig mockSseClientConfig;

    @BeforeEach
    public void setup() throws Exception {
        this.serializedDataSink = new StringWriter();
        this.callback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
        Mockito.when((Object)this.callback.startResponse((HttpResponse)ArgumentMatchers.any(), (ResponseStatusCallback)ArgumentMatchers.any(), (Charset)ArgumentMatchers.any())).thenReturn((Object)this.serializedDataSink);
        this.mockSseClientConfig = (SseClientConfig)Mockito.mock(SseClientConfig.class);
        Mockito.when((Object)this.mockSseClientConfig.getResponseCustomizerConsumer()).thenReturn(ignored -> {});
    }

    @Test
    public void startsResponseWithSseStatusCodeAndContentType() throws IOException {
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(HttpResponse.class);
        SseResponseStarter sseResponseStarter = new SseResponseStarter();
        try (SseClient ignoredClient = sseResponseStarter.startResponse(this.mockSseClientConfig, this.callback);){
            ((HttpResponseReadyCallback)Mockito.verify((Object)this.callback)).startResponse((HttpResponse)responseCaptor.capture(), (ResponseStatusCallback)ArgumentMatchers.any(), (Charset)ArgumentMatchers.any());
            HttpResponse response = (HttpResponse)responseCaptor.getValue();
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("Content-Type", SSE_CONTENT_TYPE));
        }
    }

    @Test
    public void basicSseSend() throws IOException {
        SseResponseStarter sseResponseStarter = new SseResponseStarter();
        try (SseClient sseClient = sseResponseStarter.startResponse(this.mockSseClientConfig, this.callback);){
            sseClient.sendEvent("Incredibly easy to use!");
        }
        MatcherAssert.assertThat((Object)this.serializedDataSink.toString(), (Matcher)Matchers.is((Object)"event: message\ndata: Incredibly easy to use!\n\n"));
    }
}

