/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.util.attribute.AttributeEvaluator;

public abstract class AbstractRaiseErrorProcessor
extends AbstractComponent
implements Processor,
Initialisable {
    private static final String DEFAULT_ERROR_MESSAGE = "An error occurred.";
    private AttributeEvaluator descriptionEvaluator = new AttributeEvaluator("An error occurred.", DataType.STRING);
    private String typeId;
    private ErrorType errorType;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    protected ExtendedExpressionManager expressionManager;

    public void initialise() throws InitialisationException {
        if (StringUtils.isEmpty((CharSequence)this.typeId)) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"type cannot be an empty string or null"), (Initialisable)this);
        }
        ComponentIdentifier errorTypeComponentIdentifier = this.calculateErrorIdentifier(this.typeId);
        this.errorType = (ErrorType)this.errorTypeRepository.lookupErrorType(errorTypeComponentIdentifier).orElseThrow(() -> new InitialisationException(I18nMessageFactory.createStaticMessage((String)String.format("Could not find error '%s'.", errorTypeComponentIdentifier)), (Initialisable)this));
        this.descriptionEvaluator.initialize(this.expressionManager);
    }

    protected abstract ComponentIdentifier calculateErrorIdentifier(String var1);

    protected abstract TypedException getException(ErrorType var1, String var2, CoreEvent var3);

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        String message = (String)this.descriptionEvaluator.resolveValue(event);
        throw this.getException(this.errorType, message, event);
    }

    public void setType(String type) {
        this.typeId = type;
    }

    public void setDescription(String description) {
        this.descriptionEvaluator = new AttributeEvaluator(description, DataType.STRING);
    }
}

