/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.enricher;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.AnyTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.BinaryTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.property.SinceMuleVersionModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.annotations.CustomDefinedStaticTypeAnnotation;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.JavaModelLoaderUtils;

public final class JavaMimeTypeParametersDeclarationEnricher
implements WalkingDeclarationEnricher {
    private static SinceMuleVersionModelProperty SINCE_MULE_VERSION_MODEL_PROPERTY = new SinceMuleVersionModelProperty("4.2.0");

    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(final ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){
            private final ClassTypeLoader typeLoader;
            {
                this.typeLoader = extensionLoadingContext.getTypeLoader();
            }

            protected void onOperation(OperationDeclaration declaration) {
                Optional<MetadataType> outputType = declaration.getModelProperty(ExtensionOperationDescriptorModelProperty.class).map(ExtensionOperationDescriptorModelProperty::getOperationElement).map(OperationElement::getOperationReturnMetadataType);
                this.declareMimeTypeParameters((ExecutableComponentDeclaration<?>)declaration, outputType);
            }

            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                Optional<MetadataType> outputType = declaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class).filter(mp -> mp.getType() instanceof SourceElement).map(mp -> (SourceElement)mp.getType()).map(SourceElement::getReturnMetadataType);
                this.declareMimeTypeParameters((ExecutableComponentDeclaration<?>)declaration, outputType);
            }

            private void declareOutputEncodingParameter(ParameterGroupDeclaration group, boolean shouldAddSinceMuleVersionModelProperty) {
                group.addParameter(this.newParameter("outputEncoding", "The encoding of the payload that this operation outputs.", shouldAddSinceMuleVersionModelProperty));
            }

            private void declareOutputMimeTypeParameter(ParameterGroupDeclaration group, boolean shouldAddSinceMuleVersionModelProperty) {
                group.addParameter(this.newParameter("outputMimeType", "The mime type of the payload that this operation outputs.", shouldAddSinceMuleVersionModelProperty));
            }

            private void declareOutputEncodingParameter(ParameterGroupDeclaration group) {
                this.declareOutputEncodingParameter(group, false);
            }

            private void declareOutputMimeTypeParameter(ParameterGroupDeclaration group) {
                this.declareOutputMimeTypeParameter(group, false);
            }

            private void declareMimeTypeParameters(final ExecutableComponentDeclaration<?> declaration, Optional<MetadataType> outputType) {
                final MediaTypeModelProperty property = declaration.getModelProperty(MediaTypeModelProperty.class).orElse(null);
                outputType.orElse(declaration.getOutput().getType()).accept(new MetadataTypeVisitor(){

                    public void visitString(StringType stringType) {
                        if (property == null || stringType.getAnnotation(EnumAnnotation.class).isPresent()) {
                            return;
                        }
                        if (!property.isStrict()) {
                            this.declareOutputMimeTypeParameter(declaration.getParameterGroup("General"));
                        }
                        this.replaceOutputType(declaration, property, format -> {
                            StringTypeBuilder stringTypeBuilder = BaseTypeBuilder.create((MetadataFormat)format).stringType();
                            this.enrichWithAnnotations((WithAnnotation)stringTypeBuilder, declaration.getOutput().getType().getAnnotations());
                            return stringTypeBuilder.build();
                        });
                    }

                    public void visitArrayType(ArrayType arrayType) {
                        MetadataType itemType = arrayType.getType();
                        if (itemType instanceof MessageMetadataType && (itemType = (MetadataType)((MessageMetadataType)itemType).getPayloadType().orElse(null)) == null) {
                            return;
                        }
                        if (itemType instanceof StringType && !itemType.getAnnotation(EnumAnnotation.class).isPresent()) {
                            ParameterGroupDeclaration group = declaration.getParameterGroup("General");
                            this.declareOutputMimeTypeParameter(group, true);
                        } else if (itemType instanceof BinaryType || itemType instanceof AnyType) {
                            ParameterGroupDeclaration group = declaration.getParameterGroup("General");
                            this.declareOutputMimeTypeParameter(group, true);
                            this.declareOutputEncodingParameter(group, true);
                        }
                    }

                    public void visitBinaryType(BinaryType binaryType) {
                        if (property == null) {
                            return;
                        }
                        if (!property.isStrict()) {
                            ParameterGroupDeclaration group = declaration.getParameterGroup("General");
                            this.declareOutputMimeTypeParameter(group);
                            this.declareOutputEncodingParameter(group);
                        }
                        this.replaceOutputType(declaration, property, format -> {
                            BinaryTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)format).binaryType();
                            this.enrichWithAnnotations((WithAnnotation)builder, declaration.getOutput().getType().getAnnotations());
                            return builder.build();
                        });
                    }

                    public void visitAnyType(AnyType anyType) {
                        if (property == null) {
                            return;
                        }
                        if (!property.isStrict()) {
                            boolean shouldAddSinceMuleVersionModelProperty = !JavaModelLoaderUtils.isInputStream((MetadataType)anyType);
                            ParameterGroupDeclaration group = declaration.getParameterGroup("General");
                            this.declareOutputMimeTypeParameter(group, shouldAddSinceMuleVersionModelProperty);
                            this.declareOutputEncodingParameter(group, shouldAddSinceMuleVersionModelProperty);
                        }
                        this.replaceOutputType(declaration, property, format -> {
                            AnyTypeBuilder anyTypeBuilder = BaseTypeBuilder.create((MetadataFormat)format).anyType();
                            this.enrichWithAnnotations((WithAnnotation)anyTypeBuilder, declaration.getOutput().getType().getAnnotations());
                            return anyTypeBuilder.build();
                        });
                    }

                    private void enrichWithAnnotations(WithAnnotation withAnnotationBuilder, Set<TypeAnnotation> annotations) {
                        annotations.forEach(typeAnnotation -> withAnnotationBuilder.with(typeAnnotation));
                    }
                });
            }

            private void replaceOutputType(ExecutableComponentDeclaration<?> declaration, MediaTypeModelProperty property, Function<MetadataFormat, MetadataType> type) {
                if (!this.shouldOverrideMetadataFormat(declaration)) {
                    return;
                }
                property.getMediaType().ifPresent(mediaType -> {
                    OutputDeclaration output = declaration.getOutput();
                    output.setType((MetadataType)type.apply(ExtensionMetadataTypeUtils.toMetadataFormat((MediaType)mediaType)), output.hasDynamicType());
                });
            }

            private boolean shouldOverrideMetadataFormat(ExecutableComponentDeclaration declaration) {
                return !declaration.getOutput().getType().getAnnotation(CustomDefinedStaticTypeAnnotation.class).isPresent() && declaration.getOutput().getType().getMetadataFormat().equals((Object)MetadataFormat.JAVA);
            }

            private ParameterDeclaration newParameter(String name, String description) {
                return this.newParameter(name, description, false);
            }

            private ParameterDeclaration newParameter(String name, String description, boolean shouldAddSinceMuleVersionModelProperty) {
                ParameterDeclaration parameter = new ParameterDeclaration(name);
                parameter.setRequired(false);
                parameter.setExpressionSupport(ExpressionSupport.SUPPORTED);
                parameter.setType(this.typeLoader.load(String.class), false);
                parameter.setDescription(description);
                parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
                if (shouldAddSinceMuleVersionModelProperty) {
                    parameter.addModelProperty((ModelProperty)SINCE_MULE_VERSION_MODEL_PROPERTY);
                }
                return parameter;
            }
        });
    }
}

