/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.discoverer;

import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.discoverer.ReflectionServiceResolver;
import org.mule.runtime.module.service.internal.discoverer.ServiceResolver;
import org.mule.runtime.module.service.internal.manager.DefaultServiceRegistry;

public class DefaultServiceDiscoverer
implements ServiceDiscoverer {
    private final ServiceResolver serviceResolver;
    private final ServiceProviderDiscoverer serviceProviderDiscoverer;

    public DefaultServiceDiscoverer(ServiceProviderDiscoverer serviceProviderDiscoverer) {
        this(serviceProviderDiscoverer, new ReflectionServiceResolver(new DefaultServiceRegistry(), null, (service, assembly) -> service));
    }

    public DefaultServiceDiscoverer(ServiceProviderDiscoverer serviceProviderDiscoverer, ServiceResolver serviceResolver) {
        Objects.requireNonNull(serviceProviderDiscoverer, "serviceProviderDiscoverer cannot be null");
        Objects.requireNonNull(serviceResolver, "serviceDependencyResolver cannot be null");
        this.serviceResolver = serviceResolver;
        this.serviceProviderDiscoverer = serviceProviderDiscoverer;
    }

    @Override
    public List<Service> discoverServices() throws ServiceResolutionError {
        try {
            List<ServiceAssembly> assemblies = this.discoverAssemblies();
            return this.serviceResolver.resolveServices(assemblies);
        }
        catch (ServiceResolutionError e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceResolutionError(e.getMessage(), e);
        }
    }

    protected List<ServiceAssembly> discoverAssemblies() throws ServiceResolutionError {
        return this.serviceProviderDiscoverer.discover();
    }
}

