/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly.websocket;

import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.websocket.AHCWebSocketListenerAdapter;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.util.MiscUtils;
import java.util.concurrent.CompletableFuture;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.SimpleWebSocket;
import org.glassfish.grizzly.websockets.Utils;
import org.glassfish.grizzly.websockets.WebSocketListener;

public final class GrizzlyWebSocketAdapter
implements WebSocket {
    final SimpleWebSocket gWebSocket;
    final boolean bufferFragments;

    public static GrizzlyWebSocketAdapter newInstance(AsyncHttpProviderConfig<?, ?> config, ProtocolHandler protocolHandler) {
        SimpleWebSocket ws = new SimpleWebSocket(protocolHandler, new WebSocketListener[0]);
        boolean bufferFragments = true;
        if (config instanceof GrizzlyAsyncHttpProviderConfig) {
            bufferFragments = (Boolean)((GrizzlyAsyncHttpProviderConfig)config).getProperty(GrizzlyAsyncHttpProviderConfig.Property.BUFFER_WEBSOCKET_FRAGMENTS);
        }
        return new GrizzlyWebSocketAdapter(ws, bufferFragments);
    }

    private GrizzlyWebSocketAdapter(SimpleWebSocket gWebSocket, boolean bufferFragments) {
        this.gWebSocket = gWebSocket;
        this.bufferFragments = bufferFragments;
    }

    public org.glassfish.grizzly.websockets.WebSocket getGrizzlyWebSocket() {
        return this.gWebSocket;
    }

    @Override
    public WebSocket sendMessage(byte[] message) {
        this.gWebSocket.send(message);
        return this;
    }

    @Override
    public CompletableFuture<DataFrame> completableSend(byte[] message) {
        return Futures.completable((GrizzlyFuture)this.gWebSocket.send(message));
    }

    @Override
    public WebSocket stream(byte[] fragment, boolean last) {
        if (MiscUtils.isNonEmpty(fragment)) {
            this.gWebSocket.stream(last, fragment, 0, fragment.length);
        }
        return this;
    }

    @Override
    public CompletableFuture<DataFrame> completableStream(byte[] fragment, boolean last) {
        if (MiscUtils.isNonEmpty(fragment)) {
            return Futures.completable((GrizzlyFuture)this.gWebSocket.stream(last, fragment, 0, fragment.length));
        }
        return Utils.completedFrame((byte[])fragment, (boolean)last);
    }

    @Override
    public WebSocket stream(byte[] fragment, int offset, int len, boolean last) {
        if (MiscUtils.isNonEmpty(fragment)) {
            this.gWebSocket.stream(last, fragment, offset, len);
        }
        return this;
    }

    @Override
    public CompletableFuture<DataFrame> completableStream(byte[] fragment, int offset, int len, boolean last) {
        if (MiscUtils.isNonEmpty(fragment)) {
            return Futures.completable((GrizzlyFuture)this.gWebSocket.stream(last, fragment, offset, len));
        }
        return Utils.completedFrame((byte[])fragment, (boolean)last);
    }

    @Override
    public WebSocket sendMessage(String message) {
        this.gWebSocket.send(message);
        return this;
    }

    @Override
    public CompletableFuture<DataFrame> completableSend(String message) {
        return Futures.completable((GrizzlyFuture)this.gWebSocket.send(message));
    }

    @Override
    public WebSocket stream(String fragment, boolean last) {
        this.gWebSocket.stream(last, fragment);
        return this;
    }

    @Override
    public CompletableFuture<DataFrame> completableStream(String fragment, boolean last) {
        return Futures.completable((GrizzlyFuture)this.gWebSocket.stream(last, fragment));
    }

    @Override
    public WebSocket sendPing(byte[] payload) {
        this.gWebSocket.sendPing(payload);
        return this;
    }

    @Override
    public WebSocket sendPong(byte[] payload) {
        this.gWebSocket.sendPong(payload);
        return this;
    }

    @Override
    public WebSocket addWebSocketListener(com.ning.http.client.ws.WebSocketListener l) {
        this.gWebSocket.add((WebSocketListener)new AHCWebSocketListenerAdapter(l, this));
        return this;
    }

    @Override
    public WebSocket removeWebSocketListener(com.ning.http.client.ws.WebSocketListener l) {
        this.gWebSocket.remove((WebSocketListener)new AHCWebSocketListenerAdapter(l, this));
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.gWebSocket.isConnected();
    }

    @Override
    public void close() {
        this.gWebSocket.close();
    }

    @Override
    public CompletableFuture<DataFrame> close(int code, String reason) {
        return this.gWebSocket.completableClose(code, reason);
    }

    public org.glassfish.grizzly.websockets.WebSocket getGrizzlyDelegate() {
        return this.gWebSocket;
    }
}

