/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.type;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.metadata.fixed.AttributesJsonType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.AttributesXmlType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputJsonType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputXmlType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.annotations.CustomDefinedStaticTypeAnnotation;
import org.mule.runtime.module.extension.internal.loader.enricher.MetadataTypeEnricher;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.sdk.api.annotation.metadata.fixed.OutputXmlType;
import org.mule.sdk.api.metadata.resolving.StaticResolver;

public class CustomStaticTypeUtils {
    private static final MetadataTypeEnricher enricher = new MetadataTypeEnricher();

    public static MetadataType getOperationOutputType(OperationElement operationElement) {
        MetadataType declarationType = operationElement.getOperationReturnMetadataType();
        return CustomStaticTypeUtils.getOutputType(operationElement, declarationType, "operation", operationElement.getName()).map(customType -> CustomStaticTypeUtils.enrichCustomType(declarationType, customType)).orElse(declarationType);
    }

    public static MetadataType getOperationAttributesType(OperationElement operationElement) {
        MetadataType declarationType = operationElement.getOperationAttributesMetadataType();
        return CustomStaticTypeUtils.getAttributesType(operationElement, declarationType, "operation", operationElement.getName()).map(customType -> CustomStaticTypeUtils.enrichCustomType(declarationType, customType)).orElse(declarationType);
    }

    public static MetadataType getParameterType(ExtensionParameter parameterElement) {
        MetadataType declarationType = parameterElement.getType().asMetadataType();
        return CustomStaticTypeUtils.getInputType(parameterElement, declarationType, "parameter", parameterElement.getName()).map(customType -> CustomStaticTypeUtils.enrichCustomType(declarationType, customType)).orElse(declarationType);
    }

    public static MetadataType getSourceOutputType(SourceElement sourceElement) {
        MetadataType declarationType = sourceElement.getReturnMetadataType();
        return CustomStaticTypeUtils.getOutputType(sourceElement, declarationType, "source", sourceElement.getName()).map(customType -> CustomStaticTypeUtils.enrichCustomType(declarationType, customType)).orElse(declarationType);
    }

    public static MetadataType getSourceAttributesType(SourceElement sourceElement) {
        MetadataType declarationType = sourceElement.getAttributesMetadataType();
        return CustomStaticTypeUtils.getAttributesType(sourceElement, declarationType, "source", sourceElement.getName()).map(customType -> CustomStaticTypeUtils.enrichCustomType(declarationType, customType)).orElse(declarationType);
    }

    private static Optional<MetadataType> getAttributesType(WithAnnotations element, MetadataType outputType, String elementType, String elementName) {
        Optional<MetadataType> result = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, AttributesXmlType.class, org.mule.sdk.api.annotation.metadata.fixed.AttributesXmlType.class, outputXmlTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getXmlType(outputXmlTypeAnnotationValueFetcher.getStringValue(AttributesXmlType::schema), outputXmlTypeAnnotationValueFetcher.getStringValue(AttributesXmlType::qname)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null), outputXmlTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getXmlType(outputXmlTypeAnnotationValueFetcher.getStringValue(org.mule.sdk.api.annotation.metadata.fixed.AttributesXmlType::schema), outputXmlTypeAnnotationValueFetcher.getStringValue(org.mule.sdk.api.annotation.metadata.fixed.AttributesXmlType::qname)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null));
        if (result.isPresent()) {
            return result;
        }
        result = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, AttributesJsonType.class, org.mule.sdk.api.annotation.metadata.fixed.AttributesJsonType.class, outputJsonTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getJsonType(outputJsonTypeAnnotationValueFetcher.getStringValue(AttributesJsonType::schema)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null), outputJsonTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getJsonType(outputJsonTypeAnnotationValueFetcher.getStringValue(org.mule.sdk.api.annotation.metadata.fixed.AttributesJsonType::schema)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null));
        if (result.isPresent()) {
            return result;
        }
        result = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, OutputResolver.class, org.mule.sdk.api.annotation.metadata.OutputResolver.class, outputTypeAnnotationValueFetcher -> {
            Type type = outputTypeAnnotationValueFetcher.getClassValue(OutputResolver::attributes);
            Class declaringClass = type.getDeclaringClass().orElse(null);
            if (declaringClass != null && CustomStaticTypeUtils.isStaticResolver(declaringClass)) {
                return CustomStaticTypeUtils.getCustomStaticType(declaringClass).orElse(null);
            }
            return null;
        }, outputTypeAnnotationValueFetcher -> {
            Type type = outputTypeAnnotationValueFetcher.getClassValue(org.mule.sdk.api.annotation.metadata.OutputResolver::attributes);
            Class declaringClass = type.getDeclaringClass().orElse(null);
            if (declaringClass != null && CustomStaticTypeUtils.isStaticResolver(declaringClass)) {
                return CustomStaticTypeUtils.getCustomStaticType(declaringClass).orElse(null);
            }
            return null;
        });
        if (result.isPresent()) {
            return result;
        }
        result = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, MetadataScope.class, org.mule.sdk.api.annotation.metadata.MetadataScope.class, outputTypeAnnotationValueFetcher -> {
            Type type = outputTypeAnnotationValueFetcher.getClassValue(MetadataScope::attributesResolver);
            Class declaringClass = type.getDeclaringClass().orElse(null);
            if (declaringClass != null && CustomStaticTypeUtils.isStaticResolver(declaringClass)) {
                return CustomStaticTypeUtils.getCustomStaticType(declaringClass).orElse(null);
            }
            return null;
        }, outputTypeAnnotationValueFetcher -> {
            Type type = outputTypeAnnotationValueFetcher.getClassValue(org.mule.sdk.api.annotation.metadata.MetadataScope::attributesResolver);
            Class declaringClass = type.getDeclaringClass().orElse(null);
            if (declaringClass != null && CustomStaticTypeUtils.isStaticResolver(declaringClass)) {
                return CustomStaticTypeUtils.getCustomStaticType(declaringClass).orElse(null);
            }
            return null;
        });
        if (result.isPresent()) {
            return result;
        }
        return Optional.empty();
    }

    private static Optional<MetadataType> getOutputType(WithAnnotations element, MetadataType outputType, String elementType, String elementName) {
        Optional<MetadataType> result = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, org.mule.runtime.extension.api.annotation.metadata.fixed.OutputXmlType.class, OutputXmlType.class, outputXmlTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getXmlType(outputXmlTypeAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.metadata.fixed.OutputXmlType::schema), outputXmlTypeAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.metadata.fixed.OutputXmlType::qname)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null), outputXmlTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getXmlType(outputXmlTypeAnnotationValueFetcher.getStringValue(OutputXmlType::schema), outputXmlTypeAnnotationValueFetcher.getStringValue(OutputXmlType::qname)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null));
        if (result.isPresent()) {
            return result;
        }
        result = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, OutputJsonType.class, org.mule.sdk.api.annotation.metadata.fixed.OutputJsonType.class, outputJsonTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getJsonType(outputJsonTypeAnnotationValueFetcher.getStringValue(OutputJsonType::schema)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null), outputJsonTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getJsonType(outputJsonTypeAnnotationValueFetcher.getStringValue(org.mule.sdk.api.annotation.metadata.fixed.OutputJsonType::schema)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null));
        if (result.isPresent()) {
            return result;
        }
        result = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, OutputResolver.class, org.mule.sdk.api.annotation.metadata.OutputResolver.class, outputTypeAnnotationValueFetcher -> {
            Type type = outputTypeAnnotationValueFetcher.getClassValue(OutputResolver::output);
            Class declaringClass = type.getDeclaringClass().orElse(null);
            if (declaringClass != null && CustomStaticTypeUtils.isStaticResolver(declaringClass)) {
                return CustomStaticTypeUtils.getCustomStaticType(declaringClass).orElse(null);
            }
            return null;
        }, outputTypeAnnotationValueFetcher -> {
            Type type = outputTypeAnnotationValueFetcher.getClassValue(org.mule.sdk.api.annotation.metadata.OutputResolver::output);
            Class declaringClass = type.getDeclaringClass().orElse(null);
            if (declaringClass != null && CustomStaticTypeUtils.isStaticResolver(declaringClass)) {
                return CustomStaticTypeUtils.getCustomStaticType(declaringClass).orElse(null);
            }
            return null;
        });
        if (result.isPresent()) {
            return result;
        }
        result = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, MetadataScope.class, org.mule.sdk.api.annotation.metadata.MetadataScope.class, outputTypeAnnotationValueFetcher -> {
            Type type = outputTypeAnnotationValueFetcher.getClassValue(MetadataScope::outputResolver);
            Class declaringClass = type.getDeclaringClass().orElse(null);
            if (declaringClass != null && CustomStaticTypeUtils.isStaticResolver(declaringClass)) {
                return CustomStaticTypeUtils.getCustomStaticType(declaringClass).orElse(null);
            }
            return null;
        }, outputTypeAnnotationValueFetcher -> {
            Type type = outputTypeAnnotationValueFetcher.getClassValue(org.mule.sdk.api.annotation.metadata.MetadataScope::outputResolver);
            Class declaringClass = type.getDeclaringClass().orElse(null);
            if (declaringClass != null && CustomStaticTypeUtils.isStaticResolver(declaringClass)) {
                return CustomStaticTypeUtils.getCustomStaticType(declaringClass).orElse(null);
            }
            return null;
        });
        if (result.isPresent()) {
            return result;
        }
        return Optional.empty();
    }

    private static Optional<MetadataType> getInputType(WithAnnotations element, MetadataType outputType, String elementType, String elementName) {
        Optional<MetadataType> result = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, InputXmlType.class, org.mule.sdk.api.annotation.metadata.fixed.InputXmlType.class, outputXmlTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getXmlType(outputXmlTypeAnnotationValueFetcher.getStringValue(InputXmlType::schema), outputXmlTypeAnnotationValueFetcher.getStringValue(InputXmlType::qname)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null), outputXmlTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getXmlType(outputXmlTypeAnnotationValueFetcher.getStringValue(org.mule.sdk.api.annotation.metadata.fixed.InputXmlType::schema), outputXmlTypeAnnotationValueFetcher.getStringValue(org.mule.sdk.api.annotation.metadata.fixed.InputXmlType::qname)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null));
        if (result.isPresent()) {
            return result;
        }
        result = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, InputJsonType.class, org.mule.sdk.api.annotation.metadata.fixed.InputJsonType.class, outputJsonTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getJsonType(outputJsonTypeAnnotationValueFetcher.getStringValue(InputJsonType::schema)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null), outputJsonTypeAnnotationValueFetcher -> CustomStaticTypeUtils.getJsonType(outputJsonTypeAnnotationValueFetcher.getStringValue(org.mule.sdk.api.annotation.metadata.fixed.InputJsonType::schema)).map(type -> CustomStaticTypeUtils.resolveType(type, outputType)).orElse(null));
        if (result.isPresent()) {
            return result;
        }
        result = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, TypeResolver.class, org.mule.sdk.api.annotation.metadata.TypeResolver.class, outputTypeAnnotationValueFetcher -> {
            Type type = outputTypeAnnotationValueFetcher.getClassValue(TypeResolver::value);
            Class declaringClass = type.getDeclaringClass().orElse(null);
            if (declaringClass != null && CustomStaticTypeUtils.isStaticResolver(declaringClass)) {
                return CustomStaticTypeUtils.getCustomStaticType(declaringClass).orElse(null);
            }
            return null;
        }, outputTypeAnnotationValueFetcher -> {
            Type type = outputTypeAnnotationValueFetcher.getClassValue(org.mule.sdk.api.annotation.metadata.TypeResolver::value);
            Class declaringClass = type.getDeclaringClass().orElse(null);
            if (declaringClass != null && CustomStaticTypeUtils.isStaticResolver(declaringClass)) {
                return CustomStaticTypeUtils.getCustomStaticType(declaringClass).orElse(null);
            }
            return null;
        });
        if (result.isPresent()) {
            return result;
        }
        return Optional.empty();
    }

    private static MetadataType enrichCustomType(MetadataType declarationType, MetadataType target) {
        Class clazz = (Class)ExtensionMetadataTypeUtils.getType((MetadataType)declarationType).orElseThrow(() -> new IllegalStateException("Could not find class in type [" + String.valueOf(declarationType) + "]"));
        HashSet<TypeAnnotation> a = new HashSet<TypeAnnotation>(Arrays.asList(new TypeAnnotation[]{new ClassInformationAnnotation(clazz), new CustomDefinedStaticTypeAnnotation()}));
        return enricher.enrich(target, a);
    }

    private static MetadataType resolveType(MetadataType annotationType, MetadataType declarationType) {
        if (declarationType instanceof ArrayType) {
            ArrayTypeBuilder arrayMetadataBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType();
            arrayMetadataBuilder.of(annotationType);
            return arrayMetadataBuilder.build();
        }
        return annotationType;
    }

    private static Optional<MetadataType> getCustomStaticType(Class<?> resolver) {
        try {
            Object resolverInstance = resolver.newInstance();
            if (resolverInstance instanceof org.mule.runtime.api.metadata.resolving.StaticResolver) {
                return Optional.of(((org.mule.runtime.api.metadata.resolving.StaticResolver)resolverInstance).getStaticMetadata());
            }
            return Optional.of(((StaticResolver)resolver.newInstance()).getStaticMetadata());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Can't obtain static type for element", e);
        }
    }

    private static Optional<MetadataType> getJsonType(String schema) {
        String schemaContent;
        try (InputStream is = CustomStaticTypeUtils.getSchemaContent(schema);){
            schemaContent = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        Optional type = new JsonTypeLoader(schemaContent).load(null);
        if (!type.isPresent()) {
            throw new IllegalArgumentException("Could not load type from Json schema [" + schema + "]");
        }
        return type;
    }

    private static Optional<MetadataType> getXmlType(String schema, String qname) {
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            Optional type;
            if (StringUtils.isBlank((CharSequence)qname)) {
                throw new IllegalStateException("[" + schema + "] was specified but no associated QName to find in schema");
            }
            try (InputStream is = CustomStaticTypeUtils.getSchemaContent(schema);){
                URL schemaURL = Thread.currentThread().getContextClassLoader().getResource(schema);
                type = new XmlTypeLoader(SchemaCollector.getInstance().addSchema(schemaURL.toString(), is)).load(qname);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            if (!type.isPresent()) {
                throw new IllegalArgumentException("Type [" + qname + "] wasn't found in XML schema [" + schema + "]");
            }
            return type;
        }
        return Optional.empty();
    }

    private static InputStream getSchemaContent(String schemaName) {
        InputStream schema = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaName);
        if (schema == null) {
            throw new IllegalArgumentException("Can't load schema [" + schemaName + "]. It was not found in the resources.");
        }
        return schema;
    }

    private static boolean isStaticResolver(Class<?> resolverClazz) {
        return org.mule.runtime.api.metadata.resolving.StaticResolver.class.isAssignableFrom(resolverClazz) || StaticResolver.class.isAssignableFrom(resolverClazz);
    }
}

