/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class AsyncEntityReader
implements Runnable {
    private final InputStream content;
    private final StringBuilder sink = new StringBuilder();
    private final AtomicBoolean finished = new AtomicBoolean(false);

    public AsyncEntityReader(HttpResponse response) {
        this.content = response.getEntity().getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String partialPayload() {
        StringBuilder stringBuilder = this.sink;
        synchronized (stringBuilder) {
            return this.sink.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] buffer = new byte[1024];
        try {
            while (true) {
                int result;
                if ((result = this.content.read(buffer)) == -1) {
                    this.finished.set(true);
                    return;
                }
                StringBuilder stringBuilder = this.sink;
                synchronized (stringBuilder) {
                    String asString = new String(buffer, 0, result);
                    this.sink.append(asString);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean finished() {
        return this.finished.get();
    }
}

