/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.ServerMessageBlock;
import jcifs.util.Hexdump;

class SmbComNTCreateAndX
extends AndXServerMessageBlock {
    static final int FILE_SUPERSEDE = 0;
    static final int FILE_OPEN = 1;
    static final int FILE_CREATE = 2;
    static final int FILE_OPEN_IF = 3;
    static final int FILE_OVERWRITE = 4;
    static final int FILE_OVERWRITE_IF = 5;
    static final int FILE_WRITE_THROUGH = 2;
    static final int FILE_SEQUENTIAL_ONLY = 4;
    static final int FILE_SYNCHRONOUS_IO_ALERT = 16;
    static final int FILE_SYNCHRONOUS_IO_NONALERT = 32;
    static final int SECURITY_CONTEXT_TRACKING = 1;
    static final int SECURITY_EFFECTIVE_ONLY = 2;
    private int rootDirectoryFid;
    private int extFileAttributes;
    private int shareAccess;
    private int createDisposition;
    private int createOptions;
    private int impersonationLevel;
    private long allocationSize;
    private byte securityFlags;
    private int namelen_index;
    int flags0;
    int desiredAccess;

    SmbComNTCreateAndX(String name, int flags, int access, int shareAccess, int extFileAttributes, int createOptions, ServerMessageBlock andx) {
        super(andx);
        this.path = name;
        this.command = (byte)-94;
        this.desiredAccess = access;
        this.desiredAccess |= 0x89;
        this.extFileAttributes = extFileAttributes;
        this.shareAccess = shareAccess;
        this.createDisposition = (flags & 0x40) == 64 ? ((flags & 0x10) == 16 ? 5 : 4) : ((flags & 0x10) == 16 ? ((flags & 0x20) == 32 ? 2 : 3) : 1);
        this.createOptions = (createOptions & 1) == 0 ? createOptions | 0x40 : createOptions;
        this.impersonationLevel = 2;
        this.securityFlags = (byte)3;
    }

    @Override
    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex++] = 0;
        this.namelen_index = dstIndex;
        SmbComNTCreateAndX.writeInt4(this.flags0, dst, dstIndex += 2);
        SmbComNTCreateAndX.writeInt4(this.rootDirectoryFid, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt4(this.desiredAccess, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt8(this.allocationSize, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt4(this.extFileAttributes, dst, dstIndex += 8);
        SmbComNTCreateAndX.writeInt4(this.shareAccess, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt4(this.createDisposition, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt4(this.createOptions, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt4(this.impersonationLevel, dst, dstIndex += 4);
        dstIndex += 4;
        dst[dstIndex++] = this.securityFlags;
        return dstIndex - start;
    }

    @Override
    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int n = this.writeString(this.path, dst, dstIndex);
        SmbComNTCreateAndX.writeInt2(this.useUnicode ? this.path.length() * 2 : n, dst, this.namelen_index);
        return n;
    }

    @Override
    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("SmbComNTCreateAndX[" + super.toString() + ",flags=0x" + Hexdump.toHexString(this.flags0, 2) + ",rootDirectoryFid=" + this.rootDirectoryFid + ",desiredAccess=0x" + Hexdump.toHexString(this.desiredAccess, 4) + ",allocationSize=" + this.allocationSize + ",extFileAttributes=0x" + Hexdump.toHexString(this.extFileAttributes, 4) + ",shareAccess=0x" + Hexdump.toHexString(this.shareAccess, 4) + ",createDisposition=0x" + Hexdump.toHexString(this.createDisposition, 4) + ",createOptions=0x" + Hexdump.toHexString(this.createOptions, 8) + ",impersonationLevel=0x" + Hexdump.toHexString(this.impersonationLevel, 4) + ",securityFlags=0x" + Hexdump.toHexString(this.securityFlags, 2) + ",name=" + this.path + "]");
    }
}

