/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.tck.junit5.DynamicPort;

public abstract class AbstractHttpClientTestCase
extends AbstractHttpServiceTestCase {
    protected static final int TIMEOUT = 10000;
    @DynamicPort(systemProperty="port")
    Integer port;
    protected HttpServer server;

    public AbstractHttpClientTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.server = this.service.getServerFactory().create(this.getServerConfigurationBuilder().build());
        this.server.start();
        RequestHandler requestHandler = this.getRequestHandler();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(requestHandler.getContextClassLoader());
            this.server.addRequestHandler("/*", requestHandler);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    protected HttpServerConfiguration.Builder getServerConfigurationBuilder() throws Exception {
        return new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.intValue()).setName("client-test-server");
    }

    protected abstract HttpResponse setUpHttpResponse(HttpRequest var1);

    protected String getUri() {
        return "http://localhost:" + this.port;
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.dispose();
        }
    }

    protected HttpRequestOptions getDefaultOptions(int responseTimeout) {
        return HttpRequestOptions.builder().responseTimeout(responseTimeout).build();
    }

    protected RequestHandler getRequestHandler() {
        return (requestContext, responseCallback) -> responseCallback.responseReady(this.setUpHttpResponse(requestContext.getRequest()), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
    }
}

