/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.qameta.allure.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.common.server.sse.FutureCompleterCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.client.sse.FixedSizeStream;
import org.mule.service.http.test.common.client.sse.ThrowingStream;
import org.mule.tck.junit5.DynamicPort;

@Feature(value="HTTP/2 Support")
class Http2ClientServerRequestsTestCase
extends AbstractHttpServiceTestCase {
    private static final int RESP_TIMEOUT_MS = 4000;
    private static final int RESP_SIZE = 65536;
    @DynamicPort(systemProperty="serverPort")
    Integer serverPort;
    private HttpServer httpServer;
    private HttpClient httpClient;
    private final CompletableFuture<HttpRequestContext> seenRequestCtx = new CompletableFuture();
    private final CompletableFuture<Void> responseStatusFuture = new CompletableFuture();
    private final ResponseStatusCallback responseStatusCallback = new FutureCompleterCallback(this.responseStatusFuture);
    private final Latch receivedRequest = new Latch();
    private final Latch readyToSendResponse = new Latch();

    public Http2ClientServerRequestsTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setUp() throws Exception {
        this.httpServer = this.createServer();
        this.httpClient = this.createClient();
    }

    @AfterEach
    void tearDown() {
        this.readyToSendResponse.release();
        this.httpClient.stop();
        this.httpServer.stop().dispose();
    }

    @Test
    void sendGet() throws ExecutionException, InterruptedException {
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        this.httpClient.sendAsync(request).get();
        HttpRequest requestInServer = this.seenRequestCtx.get().getRequest();
        MatcherAssert.assertThat((Object)requestInServer.getMethod(), (Matcher)Matchers.is((Object)"GET"));
        MatcherAssert.assertThat((Object)requestInServer.getPath(), (Matcher)Matchers.is((Object)"/test"));
        MatcherAssert.assertThat((Object)requestInServer.getProtocol().asString(), (Matcher)Matchers.is((Object)"HTTP/2"));
        Assertions.assertDoesNotThrow(() -> this.responseStatusFuture.get(4000L, TimeUnit.MILLISECONDS));
    }

    @Test
    void sendGetWithQueryParams() throws ExecutionException, InterruptedException {
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).addQueryParam("queryParam1", "value1.1").addQueryParam("queryParam1", "value1.2").addQueryParam("queryParam2", "value2").build();
        this.httpClient.sendAsync(request).get();
        HttpRequest requestInServer = this.seenRequestCtx.get().getRequest();
        MatcherAssert.assertThat((Object)requestInServer.getQueryParams().getAll((Object)"queryParam1"), (Matcher)Matchers.contains((Object[])new String[]{"value1.1", "value1.2"}));
        MatcherAssert.assertThat((Object)((String)requestInServer.getQueryParams().get((Object)"queryParam2")), (Matcher)Matchers.is((Object)"value2"));
        Assertions.assertDoesNotThrow(() -> this.responseStatusFuture.get(4000L, TimeUnit.MILLISECONDS));
    }

    @Test
    void sendGetWithHeaders() throws ExecutionException, InterruptedException {
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).addHeader("header1", "value1")).addHeader("header2", "value2")).build();
        this.httpClient.sendAsync(request).get();
        HttpRequest requestInServer = this.seenRequestCtx.get().getRequest();
        MatcherAssert.assertThat((Object)((String)requestInServer.getHeaders().get((Object)"header1")), (Matcher)Matchers.is((Object)"value1"));
        MatcherAssert.assertThat((Object)((String)requestInServer.getHeaders().get((Object)"header2")), (Matcher)Matchers.is((Object)"value2"));
        Assertions.assertDoesNotThrow(() -> this.responseStatusFuture.get(4000L, TimeUnit.MILLISECONDS));
    }

    @Test
    void sendGetWithMultimapHeaders() throws ExecutionException, InterruptedException {
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).addHeader("header1", "value1.1")).addHeader("header1", "value1.2")).addHeader("header2", "value2")).build();
        this.httpClient.sendAsync(request).get();
        HttpRequest requestInServer = this.seenRequestCtx.get().getRequest();
        MatcherAssert.assertThat((Object)requestInServer.getHeaders().getAll((Object)"header1"), (Matcher)Matchers.contains((Object[])new String[]{"value1.1", "value1.2"}));
        MatcherAssert.assertThat((Object)((String)requestInServer.getHeaders().get((Object)"header2")), (Matcher)Matchers.is((Object)"value2"));
        Assertions.assertDoesNotThrow(() -> this.responseStatusFuture.get(4000L, TimeUnit.MILLISECONDS));
    }

    @Test
    void whenSendingResponseFailsFlushingThenCallbackIsCalled() throws InterruptedException {
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/testLatched".formatted(this.serverPort)).build();
        CompletableFuture resp = this.httpClient.sendAsync(request, HttpRequestOptions.builder().responseTimeout(100).build());
        this.receivedRequest.await();
        MatcherAssert.assertThat((Object)((ExecutionException)Assertions.assertThrows(ExecutionException.class, resp::get)), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)IsInstanceOf.instanceOf(TimeoutException.class)));
        this.readyToSendResponse.release();
        MatcherAssert.assertThat((Object)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.responseStatusFuture.get(4000L, TimeUnit.MILLISECONDS))), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)IsInstanceOf.instanceOf(ClosedChannelException.class)));
    }

    @Test
    void whenSendingResponseFailsBeforeWriteThenCallbackIsCalled() throws InterruptedException {
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/testStreamThrows".formatted(this.serverPort)).build();
        this.httpClient.sendAsync(request);
        this.receivedRequest.await();
        this.readyToSendResponse.release();
        MatcherAssert.assertThat((Object)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.responseStatusFuture.get(4000L, TimeUnit.MILLISECONDS))), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"Kaboom!"))));
    }

    private HttpClient createClient() throws CreateException {
        HttpClient client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("HTTP/2 Client").setHttp2Config(new Http2ProtocolConfig(true)).setTlsContextFactory(TlsContextFactory.builder().trustStorePath("trustStore").trustStorePassword("mulepassword").insecureTrustStore(true).build()).build());
        client.start();
        return client;
    }

    private HttpServer createServer() throws ServerCreationException, IOException, CreateException {
        HttpServer server = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setName("HTTP/2 Server").setHost("localhost").setPort(this.serverPort.intValue()).setHttp2Config(new Http2ProtocolConfig(true)).setTlsContextFactory(TlsContextFactory.builder().keyStorePath("serverKeystore").keyStorePassword("mulepassword").keyAlias("muleserver").keyPassword("mulepassword").keyStoreAlgorithm("PKIX").build()).build());
        server.start();
        server.addRequestHandler("/test", (ctx, callback) -> {
            this.seenRequestCtx.complete(ctx);
            callback.responseReady(HttpResponse.builder().build(), this.responseStatusCallback);
        });
        server.addRequestHandler("/testLatched", (ctx, callback) -> {
            this.seenRequestCtx.complete(ctx);
            this.receivedRequest.release();
            try {
                this.readyToSendResponse.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HttpResponse resp = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity((InputStream)new FixedSizeStream(65536)))).build();
            callback.responseReady(resp, this.responseStatusCallback);
        });
        server.addRequestHandler("/testStreamThrows", (ctx, callback) -> {
            this.seenRequestCtx.complete(ctx);
            this.receivedRequest.release();
            try {
                this.readyToSendResponse.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HttpResponse resp = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ThrowingStream()))).build();
            callback.responseReady(resp, this.responseStatusCallback);
        });
        return server;
    }
}

