/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal;

import com.google.common.base.Throwables;
import java.io.File;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.deployment.model.api.DeploymentInitException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.repository.api.BundleNotFoundException;
import org.mule.runtime.module.tooling.internal.ApplicationSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtifactAgnosticService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractArtifactAgnosticService.class);
    private final ApplicationSupplier applicationSupplier;
    private Application application;

    protected AbstractArtifactAgnosticService(ApplicationSupplier applicationSupplier) {
        this.applicationSupplier = applicationSupplier;
    }

    protected Application getStartedApplication() throws ApplicationStartingException {
        if (this.application == null) {
            long startTime = System.currentTimeMillis();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Creating application");
                }
                this.application = this.applicationSupplier.get();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Application: '{}' has been created in [{}ms]", (Object)this.application.getArtifactId(), (Object)(System.currentTimeMillis() - startTime));
                }
            }
            catch (Exception e) {
                Optional<RuntimeException> bundleNotFoundException = Throwables.getCausalChain((Throwable)e).stream().filter(exception -> exception.getClass().equals(ArtifactNotFoundException.class) || exception.getClass().equals(ArtifactResolutionException.class)).findFirst().map(exception -> new BundleNotFoundException(exception));
                if (bundleNotFoundException.isPresent()) {
                    throw bundleNotFoundException.get();
                }
                Throwables.propagateIfPossible((Throwable)e, MuleRuntimeException.class);
                throw new MuleRuntimeException((Throwable)e);
            }
            try {
                startTime = System.currentTimeMillis();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Starting application: '{}'", (Object)this.application.getArtifactId());
                }
                this.application.install();
                if (this.isLazyInit().booleanValue()) {
                    try {
                        this.application.lazyInitTooling(this.isLazyInitEnableXmlValidations() == false);
                        this.application.getArtifactContext().getRegistry().lookupByType(LazyComponentInitializer.class).ifPresent(lazyInit -> lazyInit.initializeComponents(comp -> true));
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof ConfigurationException) {
                            throw new DeploymentInitException(I18nMessageFactory.createStaticMessage((String)e.getCause().getMessage()), e.getCause());
                        }
                        throw e;
                    }
                } else {
                    this.application.initTooling();
                }
                this.application.start();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Application: '{}' has been started in [{}ms]", (Object)this.application.getArtifactId(), (Object)(System.currentTimeMillis() - startTime));
                }
            }
            catch (Exception e) {
                this.dispose();
                throw new ApplicationStartingException(e);
            }
        }
        return this.application;
    }

    private Boolean isLazyInit() {
        return ((ApplicationDescriptor)this.application.getDescriptor()).getDeploymentProperties().map(deplProps -> (String)deplProps.getOrDefault((Object)"mule.application.deployment.lazyInit", "false")).map(Boolean::valueOf).orElse(false);
    }

    private Boolean isLazyInitEnableXmlValidations() {
        return ((ApplicationDescriptor)this.application.getDescriptor()).getDeploymentProperties().map(deplProps -> (String)deplProps.getOrDefault((Object)"mule.application.deployment.lazyInit.enableXmlValidations", "false")).map(Boolean::valueOf).orElse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T withTemporaryApplication(Function<Application, T> function, Function<Exception, T> errorHandler) {
        try {
            Application application = this.getStartedApplication();
            T t = function.apply(application);
            return t;
        }
        catch (ApplicationStartingException e) {
            T t = errorHandler.apply(e.getCauseException());
            return t;
        }
        finally {
            this.dispose();
        }
    }

    protected void dispose() {
        if (this.application != null) {
            this.disposeApp();
        }
    }

    private void disposeApp() {
        Application finalApplication = this.application;
        this.doWithoutFail(() -> ((Application)finalApplication).stop());
        this.doWithoutFail(() -> ((Application)finalApplication).dispose());
        this.doWithoutFail(() -> FileUtils.deleteTree((File)finalApplication.getLocation()));
        this.application = null;
    }

    private void doWithoutFail(Runnable runnable) {
        block2: {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static class ApplicationStartingException
    extends Exception {
        private ApplicationStartingException(Exception cause) {
            super(cause);
        }

        public Exception getCauseException() {
            return (Exception)this.getCause();
        }
    }
}

