/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.mule.runtime.api.tx.xa.ResourceManagerException;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.internal.transaction.xa.AbstractResourceManager;
import org.mule.runtime.core.internal.transaction.xa.AbstractTransactionContext;
import org.mule.runtime.core.internal.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.runtime.core.internal.util.queue.AbstractQueueSession;
import org.mule.runtime.core.internal.util.queue.LocalQueueTransactionContext;
import org.mule.runtime.core.internal.util.queue.LocalTxQueueTransactionContext;
import org.mule.runtime.core.internal.util.queue.QueueProvider;
import org.mule.runtime.core.internal.util.queue.QueueTransactionContext;
import org.mule.runtime.core.internal.util.queue.QueueXaResource;
import org.mule.runtime.core.internal.util.queue.QueueXaResourceManager;
import org.mule.runtime.core.internal.util.xa.XaTransactionRecoverer;

public class TransactionalQueueSession
extends AbstractQueueSession {
    private final QueueXaResource queueXaResource;
    private final AbstractResourceManager resourceManager;
    private final LocalTxQueueTransactionJournal localTxTransactionJournal;
    private final ReentrantReadWriteLock txContextReadWriteLock;
    private LocalQueueTransactionContext singleResourceTxContext;

    public TransactionalQueueSession(QueueProvider queueProvider, QueueXaResourceManager xaResourceManager, AbstractResourceManager resourceManager, XaTransactionRecoverer xaTransactionRecoverer, LocalTxQueueTransactionJournal localTxTransactionJournal, LifecycleState deploymentLifecycleState) {
        super(queueProvider, deploymentLifecycleState);
        this.localTxTransactionJournal = localTxTransactionJournal;
        this.resourceManager = resourceManager;
        this.queueXaResource = new QueueXaResource(xaResourceManager, xaTransactionRecoverer, this.getQueueProvider());
        this.txContextReadWriteLock = new ReentrantReadWriteLock();
    }

    @Override
    protected QueueTransactionContext getTransactionalContext() {
        if (this.singleResourceTxContext != null) {
            return this.singleResourceTxContext;
        }
        return (QueueTransactionContext)this.queueXaResource.getTransactionContext();
    }

    public void begin() throws ResourceManagerException {
        ReentrantReadWriteLock.WriteLock writeLock = this.txContextReadWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.getTransactionalContext() != null) {
                throw new IllegalStateException("Cannot start local transaction. A local transaction already in progress.");
            }
            this.singleResourceTxContext = new LocalTxQueueTransactionContext(this.localTxTransactionJournal, this.getQueueProvider(), this.txContextReadWriteLock.readLock());
            this.resourceManager.beginTransaction((AbstractTransactionContext)((Object)this.singleResourceTxContext));
        }
        finally {
            writeLock.unlock();
        }
    }

    public void commit() throws ResourceManagerException {
        ReentrantReadWriteLock.WriteLock writeLock = this.txContextReadWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.singleResourceTxContext == null) {
                throw new IllegalStateException("Cannot commit local transaction as no transaction was begun");
            }
            this.resourceManager.commitTransaction((AbstractTransactionContext)((Object)this.singleResourceTxContext));
            this.singleResourceTxContext = null;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void rollback() throws ResourceManagerException {
        ReentrantReadWriteLock.WriteLock writeLock = this.txContextReadWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.singleResourceTxContext == null) {
                throw new IllegalStateException("Cannot commit local transaction as no transaction was begun");
            }
            this.resourceManager.rollbackTransaction((AbstractTransactionContext)((Object)this.singleResourceTxContext));
            this.singleResourceTxContext = null;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return this.queueXaResource.isSameRM(xares);
    }

    public void start(Xid xid, int flags) throws XAException {
        this.queueXaResource.start(xid, flags);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.queueXaResource.end(xid, flags);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.queueXaResource.commit(xid, onePhase);
    }

    public void rollback(Xid xid) throws XAException {
        this.queueXaResource.rollback(xid);
    }

    public int prepare(Xid xid) throws XAException {
        return this.queueXaResource.prepare(xid);
    }

    public void forget(Xid xid) throws XAException {
        this.queueXaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.queueXaResource.getTransactionTimeout();
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        return this.queueXaResource.setTransactionTimeout(timeout);
    }

    public Xid[] recover(int i) throws XAException {
        return this.queueXaResource.recover(i);
    }
}

