/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.threading;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.mule.runtime.api.profiling.threading.ThreadSnapshot;
import org.mule.runtime.api.profiling.threading.ThreadSnapshotCollector;
import org.mule.runtime.core.internal.profiling.threading.DefaultThreadSnapshot;

public class JvmThreadSnapshotCollector
implements ThreadSnapshotCollector {
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public ThreadSnapshot getCurrentThreadSnapshot() {
        long id = Thread.currentThread().getId();
        ThreadInfo threadInfo = threadMXBean.getThreadInfo(id);
        return DefaultThreadSnapshot.builder().withBlockedTime(threadInfo.getBlockedTime()).withWaitedTime(threadInfo.getWaitedTime()).withCPUTime(threadMXBean.getThreadCpuTime(id)).build();
    }

    static {
        threadMXBean.setThreadContentionMonitoringEnabled(true);
        threadMXBean.setThreadCpuTimeEnabled(true);
    }
}

