/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.privileged.processor.AbstractExecutableComponent;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ProcessorChainRouter
extends AbstractExecutableComponent
implements Lifecycle {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessorChainRouter.class);
    @Inject
    private MuleContext muleContext;
    private String name;
    private List<Processor> processors = Collections.emptyList();
    private MessageProcessorChain processorChain;

    @Override
    protected ReactiveProcessor getExecutableFunction() {
        return publisher -> Mono.from((Publisher)publisher).transform((Function)this.processorChain);
    }

    public void setProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.processorChain);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.processorChain, LOGGER);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processorChain);
    }

    public void initialise() throws InitialisationException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("processor chain '" + this.name + "'");
        builder.chain(this.processors);
        this.processorChain = builder.build();
        LifecycleUtils.initialiseIfNeeded((Object)this.processorChain, this.muleContext);
    }
}

