/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.management.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.core.api.management.stats.Statistics;

@NoExtend
public class RouterStatistics
implements Statistics {
    private static final long serialVersionUID = 4540482357430845065L;
    public static final int TYPE_INBOUND = 1;
    public static final int TYPE_OUTBOUND = 2;
    public static final int TYPE_RESPONSE = 3;
    public static final int TYPE_BINDING = 4;
    private boolean enabled;
    private long notRouted;
    private long caughtInCatchAll;
    private long totalRouted;
    private long totalReceived;
    private final Map<String, Long> routed;
    private final int type;

    public synchronized void clear() {
        this.notRouted = 0L;
        this.totalRouted = 0L;
        this.totalReceived = 0L;
        this.caughtInCatchAll = 0L;
        this.routed.clear();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean b) {
        this.enabled = b;
    }

    public RouterStatistics(int type) {
        this.type = type;
        this.routed = new HashMap<String, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRoutedMessage(Collection endpoints) {
        if (endpoints == null || endpoints.isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(endpoints);
        Map<String, Long> map = this.routed;
        synchronized (map) {
            for (Object o : list) {
                this.incrementRoutedMessage(o);
            }
        }
    }

    public synchronized void incrementRoutedMessage(Object endpoint) {
        if (endpoint == null) {
            return;
        }
        String name = endpoint.toString();
        Long cpt = this.routed.get(name);
        long count = 0L;
        if (cpt != null) {
            count = cpt;
        }
        this.routed.put(name, ++count);
        ++this.totalRouted;
        ++this.totalReceived;
    }

    public synchronized void incrementNoRoutedMessage() {
        ++this.notRouted;
        ++this.totalReceived;
    }

    public synchronized void incrementCaughtMessage() {
        ++this.caughtInCatchAll;
    }

    public final long getCaughtMessages() {
        return this.caughtInCatchAll;
    }

    public final long getNotRouted() {
        return this.notRouted;
    }

    public final long getTotalReceived() {
        return this.totalReceived;
    }

    public final long getTotalRouted() {
        return this.totalRouted;
    }

    public final long getRouted(String endpointName) {
        Long value = this.routed.get(endpointName);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public boolean isInbound() {
        return this.type == 1;
    }

    public Map<String, Long> getRouted() {
        return this.routed;
    }
}

