/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.security;

import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.security.EncryptionStrategyNotFoundException;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecurityFilter
extends AbstractComponent
implements SecurityFilter {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SecurityManager securityManager;
    @Inject
    protected Registry registry;
    private String securityProviders;

    public final void initialise() throws InitialisationException {
        if (this.securityManager == null) {
            this.securityManager = this.registry.lookupByName("_muleSecurityManager").orElse(null);
        }
        if (this.securityManager == null) {
            throw new InitialisationException(CoreMessages.authSecurityManagerNotSet(), (Initialisable)this);
        }
        if (this.securityProviders != null) {
            String[] securityProviders;
            DefaultMuleSecurityManager localManager = new DefaultMuleSecurityManager();
            for (String sp : securityProviders = StringUtils.split((String)this.securityProviders, (String)",")) {
                SecurityProvider provider = this.securityManager.getProvider(sp.trim());
                if (provider == null) {
                    throw new InitialisationException(CoreMessages.objectNotRegistered("Security Provider", sp.trim()), (Initialisable)this);
                }
                localManager.addProvider(provider);
            }
            this.securityManager = localManager;
        }
        this.doInitialise();
    }

    protected void doInitialise() throws InitialisationException {
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public String getSecurityProviders() {
        return this.securityProviders;
    }

    @Override
    public abstract SecurityContext doFilter(CoreEvent var1) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException;
}

