/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class DefaultObjectSerializerPointsToExistingSerializer
implements Validation {
    private static final String CONFIGURATION_ELEMENT = "configuration";
    public static final ComponentIdentifier CONFIGURATION_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("configuration").build();
    private final boolean ignoreParamsWithProperties;

    public DefaultObjectSerializerPointsToExistingSerializer(boolean ignoreParamsWithProperties) {
        this.ignoreParamsWithProperties = ignoreParamsWithProperties;
    }

    public String getName() {
        return "'defaultObjectSerializer-ref' points to existing serializer";
    }

    public String getDescription() {
        return "'defaultObjectSerializer-ref' points to existing serializer.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement((Predicate)ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)CONFIGURATION_IDENTIFIER)).and(ComponentAstPredicatesFactory.currentElemement(component -> {
            ComponentParameterAst defaultSerializerNameParameter = component.getParameter("General", "defaultObjectSerializer-ref");
            if (this.ignoreParamsWithProperties && MuleAstUtils.hasPropertyPlaceholder((String)defaultSerializerNameParameter.getRawValue())) {
                return false;
            }
            return defaultSerializerNameParameter.getValue().isRight();
        }));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst param = component.getParameter("General", "defaultObjectSerializer-ref");
        return (Optional)param.getValue().reduce(l -> Optional.empty(), nameAttribute -> {
            if (artifact.topLevelComponentsStream().noneMatch(ComponentAstPredicatesFactory.equalsComponentId((String)((String)nameAttribute)))) {
                return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)param, (Validation)this, (String)("'defaultObjectSerializer-ref' is pointing to '" + String.valueOf(nameAttribute) + "' which does not exist")));
            }
            return Optional.empty();
        });
    }
}

