/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public abstract class WName {
    protected final String _prefix;
    protected final String _localName;

    protected WName(String ln) {
        this._prefix = null;
        this._localName = ln;
    }

    protected WName(String prefix, String ln) {
        this._prefix = prefix;
        this._localName = ln;
    }

    public abstract int serializedLength();

    public final String getPrefix() {
        return this._prefix;
    }

    public final String getPrefixedName() {
        if (this._prefix == null) {
            return this._localName;
        }
        return this._prefix + ":" + this._localName;
    }

    public final String getLocalName() {
        return this._localName;
    }

    public final boolean hasPrefix() {
        return this._prefix != null;
    }

    public abstract int appendBytes(byte[] var1, int var2);

    public abstract void writeBytes(OutputStream var1) throws IOException;

    public abstract int appendChars(char[] var1, int var2);

    public abstract void writeChars(Writer var1) throws IOException;

    public String toString() {
        if (this._prefix == null) {
            return this._localName;
        }
        return this._prefix + ":" + this._localName;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass() && !(o instanceof WName)) {
            return false;
        }
        WName other = (WName)o;
        if (other._localName.equals(this._localName)) {
            if (this._prefix == null) {
                return other._prefix == null;
            }
            return this._prefix.equals(other._prefix);
        }
        return false;
    }

    public int hashCode() {
        int hash = this._localName.hashCode();
        if (this._prefix != null) {
            hash ^= this._prefix.hashCode();
        }
        return hash;
    }

    public final boolean hasName(String localName) {
        if (this._prefix != null) {
            return false;
        }
        return this._localName.equals(localName);
    }

    public final boolean hasName(String prefix, String localName) {
        if (this._localName == localName) {
            if (prefix == null) {
                return this._prefix == null;
            }
            return prefix.equals(this._prefix);
        }
        if (this._localName.hashCode() != localName.hashCode()) {
            return false;
        }
        if (prefix == null ? this._prefix != null : !prefix.equals(this._prefix)) {
            return false;
        }
        return this._localName.equals(localName);
    }
}

