/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;

public class KeepAliveHandler
extends ChannelDuplexHandler {
    private static final String MULTIPART_PREFIX = "multipart";
    public static final String TIMEOUT_READING_REQUEST = "Timeout reading request";
    private boolean persistentConnection;
    private int pendingResponses;
    private boolean isInputShutdown = false;
    private HttpVersion protocolVersion = HttpVersion.HTTP_1_1;

    public KeepAliveHandler(boolean usePersistentConnections) {
        this.persistentConnection = usePersistentConnections;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            this.trackResponse(response);
            if (this.persistentConnection && !response.headers().contains("Connection") && !response.protocolVersion().isKeepAliveDefault()) {
                response.headers().set("Connection", (Object)HttpHeaderValues.KEEP_ALIVE);
            }
            if (!HttpUtil.isKeepAlive((HttpMessage)response) || !KeepAliveHandler.isSelfDefinedMessageLength(response) || KeepAliveHandler.statusDropsConnection(response.status().code())) {
                this.pendingResponses = 0;
                this.persistentConnection = false;
            }
            if (!this.shouldKeepAlive()) {
                response.headers().set("Connection", (Object)HttpHeaderValues.CLOSE);
            }
        }
        if (msg instanceof LastHttpContent && !this.shouldKeepAlive()) {
            promise = promise.unvoid().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            ++this.pendingResponses;
            if (this.persistentConnection) {
                this.persistentConnection = HttpUtil.isKeepAlive((HttpMessage)request);
            }
            this.protocolVersion = request.protocolVersion();
        }
        ctx.fireChannelRead(msg);
    }

    private void trackResponse(HttpResponse response) {
        if (!KeepAliveHandler.isInformational(response)) {
            --this.pendingResponses;
        }
    }

    private boolean shouldKeepAlive() {
        if (this.isInputShutdown) {
            return false;
        }
        return this.pendingResponses > 0 || this.persistentConnection;
    }

    private static boolean isSelfDefinedMessageLength(HttpResponse response) {
        return HttpUtil.isContentLengthSet((HttpMessage)response) || (HttpUtil.isTransferEncodingChunked((HttpMessage)response) || KeepAliveHandler.isMultipart(response) || KeepAliveHandler.isInformational(response) || response.status().code() == HttpResponseStatus.NO_CONTENT.code()) && !response.protocolVersion().equals((Object)HttpVersion.HTTP_1_0);
    }

    private static boolean isInformational(HttpResponse response) {
        return response.status().codeClass() == HttpStatusClass.INFORMATIONAL;
    }

    private static boolean isMultipart(HttpResponse response) {
        String contentType = response.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return contentType != null && contentType.regionMatches(true, 0, MULTIPART_PREFIX, 0, MULTIPART_PREFIX.length());
    }

    private static boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 499 || status == 411 || status == 413 || status == 414 || status == 417 || status == 500 || status == 503 || status == 501 || status == 505;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            if (IdleState.READER_IDLE == idleStateEvent.state() && this.pendingResponses > 0) {
                this.sendTimeoutResponse(ctx);
                return;
            }
            if (IdleState.ALL_IDLE == idleStateEvent.state() && this.pendingResponses == 0) {
                ctx.close();
                return;
            }
        }
        if (evt instanceof ChannelInputShutdownReadComplete) {
            this.isInputShutdown = true;
            if (this.pendingResponses == 0) {
                ctx.close();
                return;
            }
        }
        ctx.fireUserEventTriggered(evt);
    }

    private void sendTimeoutResponse(ChannelHandlerContext ctx) {
        ByteBuf buffer = ctx.alloc().buffer();
        buffer.writeBytes(TIMEOUT_READING_REQUEST.getBytes());
        DefaultFullHttpResponse rejection = new DefaultFullHttpResponse(this.protocolVersion, HttpResponseStatus.REQUEST_TIMEOUT, buffer);
        rejection.headers().set("Connection", (Object)HttpHeaderValues.CLOSE);
        rejection.headers().set("Content-Length", (Object)TIMEOUT_READING_REQUEST.length());
        ctx.writeAndFlush((Object)rejection).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

