/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.NamespaceDefinition;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.builder.ComponentMetadataAstBuilder;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.DefaultArtifactAst;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.ast.internal.builder.ComponentLocationVisitor;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;

public class DefaultArtifactAstBuilder
implements ArtifactAstBuilder {
    private final String artifactName;
    private final ArtifactType artifactType;
    private final Set<ExtensionModel> extensionsModels;
    private final Optional<ArtifactAst> parentArtifact;
    private final List<Supplier<ComponentAst>> topLevelComponents = new ArrayList<Supplier<ComponentAst>>();
    private final PropertiesResolver propertiesResolver = new PropertiesResolver();
    private final List<ImportedResource> importedResources = new ArrayList<ImportedResource>();
    private final ExtensionModelHelper extModelHelper;
    private final ComponentLocationVisitor componentLocationVisitor;
    private final ParameterModelUtils parameterModelUtils;
    private NamespaceDefinition namespaceDefinition;

    public DefaultArtifactAstBuilder(String artifactName, ArtifactType artifactType, Set<ExtensionModel> extensionsModels, Optional<ArtifactAst> parentArtifact, UnaryOperator<String> basePropertiesResolver, ExtensionModelHelper extModelHelper, ComponentLocationVisitor componentLocationVisitor, ParameterModelUtils parameterModelUtils) {
        this.artifactName = artifactName;
        this.artifactType = artifactType;
        this.extensionsModels = extensionsModels;
        this.parentArtifact = parentArtifact;
        this.propertiesResolver.setMappingFunction(basePropertiesResolver);
        this.extModelHelper = extModelHelper;
        this.componentLocationVisitor = componentLocationVisitor;
        this.parameterModelUtils = parameterModelUtils;
    }

    @Override
    public ComponentAstBuilder addTopLevelComponent() {
        DefaultComponentAstBuilder componentAstBuilder = new DefaultComponentAstBuilder(this.propertiesResolver, this.extModelHelper, Collections.emptyList(), this.topLevelComponents.size(), this.componentLocationVisitor, this.parameterModelUtils);
        this.topLevelComponents.add(componentAstBuilder);
        return componentAstBuilder;
    }

    public ArtifactAstBuilder addTopLevelComponent(ComponentAst topLevelComponent) {
        this.topLevelComponents.add(() -> topLevelComponent);
        return this;
    }

    @Override
    public ComponentMetadataAstBuilder createMetadataBuilder() {
        return DefaultComponentMetadataAst.builder(this.propertiesResolver);
    }

    @Override
    public void withNamespaceDefinition(NamespaceDefinition namespaceDefinition) {
        this.namespaceDefinition = namespaceDefinition;
    }

    @Override
    public ArtifactAstBuilder withImportedResource(ImportedResource resource) {
        resource.updatePropertiesResolver(this.propertiesResolver);
        this.importedResources.add(resource);
        return this;
    }

    @Override
    public ArtifactAst build() {
        List<ComponentAst> builtTopLevel = this.topLevelComponents.stream().map(Supplier::get).collect(Collectors.toList());
        return new DefaultArtifactAst(this.artifactName, this.artifactType, builtTopLevel, () -> this.extensionsModels, this.parentArtifact.orElse(null), this.propertiesResolver, this.extModelHelper, this.namespaceDefinition, this.importedResources);
    }
}

