/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transaction;

import jakarta.inject.Inject;
import jakarta.transaction.TransactionManager;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.internal.transaction.TypedTransactionFactory;
import org.mule.runtime.core.internal.transaction.xa.XaTransactionFactory;
import org.mule.runtime.core.privileged.transaction.TransactionFactory;

public final class TransactionFactoryLocator
implements Disposable {
    @Inject
    private Registry registry;
    private final Map<TransactionType, TransactionFactory> factories = new SmallMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TransactionFactory> lookUpTransactionFactory(TransactionType type) {
        TransactionFactory value;
        block9: {
            if (!this.initialized) {
                Lock writeLock = this.lock.writeLock();
                try {
                    writeLock.lock();
                    if (this.initialized) break block9;
                    try {
                        this.factories.putAll(this.getAvailableFactories());
                    }
                    catch (InitialisationException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                    this.initialized = true;
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            value = this.factories.get(type);
        }
        finally {
            readLock.unlock();
        }
        return Optional.ofNullable(value);
    }

    public void dispose() {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.factories.clear();
            this.initialized = false;
        }
        finally {
            writeLock.unlock();
        }
    }

    private Map<TransactionType, TypedTransactionFactory> getAvailableFactories() throws InitialisationException {
        EnumMap<TransactionType, TypedTransactionFactory> discoveredFactories = new EnumMap<TransactionType, TypedTransactionFactory>(TransactionType.class);
        ServiceLoader<TypedTransactionFactory> serviceLoader = ServiceLoader.load(TypedTransactionFactory.class, this.getClass().getClassLoader());
        for (TypedTransactionFactory factory : serviceLoader) {
            if (factory instanceof XaTransactionFactory) {
                XaTransactionFactory xaTxFactory = (XaTransactionFactory)((Object)factory);
                this.registry.lookupByType(TransactionManager.class).ifPresent(xaTxFactory::setTransactionManager);
            }
            discoveredFactories.put(factory.getType(), factory);
        }
        return discoveredFactories;
    }
}

