/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal.singleapp;

import com.google.common.util.concurrent.Futures;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.StartupListener;
import org.mule.runtime.module.deployment.internal.CompositeDeploymentListener;
import org.mule.runtime.module.deployment.internal.DefaultArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DefaultArtifactDeployer;
import org.mule.runtime.module.deployment.internal.DeploymentDirectoryWatcher;
import org.mule.runtime.module.deployment.internal.DeploymentFileResolver;
import org.mule.runtime.module.deployment.internal.DeploymentUtils;
import org.mule.runtime.module.deployment.internal.DomainArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DomainBundleArchiveDeployer;
import org.mule.runtime.module.deployment.internal.singleapp.SingleAppApplicationDeployerBuilder;
import org.mule.runtime.module.deployment.internal.singleapp.SingleAppDomainDeployerBuilder;
import org.mule.runtime.module.deployment.internal.util.DebuggableReentrantLock;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleAppDeploymentService
implements DeploymentService,
Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleAppDeploymentService.class);
    public static final String MULE_APPS_PATH_ENV = "MULE_APPS_PATH";
    private final ReentrantLock deploymentLock = new DebuggableReentrantLock(true);
    private static final Scheduler SINGLE_SCHEDULER = new StartUpDeploymentServiceScheduler();
    private final CompositeDeploymentListener applicationDeploymentListener = new CompositeDeploymentListener();
    private final CompositeDeploymentListener domainDeploymentListener = new CompositeDeploymentListener();
    private final List<StartupListener> startupListeners = new CopyOnWriteArrayList<StartupListener>();
    private final DomainArchiveDeployer domainDeployer;
    private final ObservableList<Domain> domains = new ObservableList();
    private final ObservableList<Application> applications = new ObservableList();
    private final DeploymentFileResolver fileResolver;
    private final Supplier<SchedulerService> artifactStartExecutorSupplier;
    private DefaultArchiveDeployer<ApplicationDescriptor, Application> applicationDeployer;
    private Consumer<Throwable> deploymentErrorConsumer = t -> {};
    private DeploymentDirectoryWatcher deploymentDirectoryWatcher;
    private final CompositeDeploymentListener domainBundleDeploymentListener = new CompositeDeploymentListener();

    public SingleAppDeploymentService(SingleAppDomainDeployerBuilder singleAppDomainDeployerBuilder, SingleAppApplicationDeployerBuilder applicationDeployerBuilder, DeploymentFileResolver fileResolver, List<Application> applications, List<Domain> domains, Supplier<SchedulerService> artifactStartExecutorSupplier) {
        this.applications.addAll(applications);
        this.domains.addAll(domains);
        this.fileResolver = fileResolver;
        this.artifactStartExecutorSupplier = artifactStartExecutorSupplier;
        LazyValue artifactStartExecutor = new LazyValue((Object)SINGLE_SCHEDULER);
        DefaultArtifactDeployer<Application> applicationMuleDeployer = new DefaultArtifactDeployer<Application>((Supplier<Scheduler>)artifactStartExecutor);
        this.domainDeployer = singleAppDomainDeployerBuilder.withDomains(this.domains).withDeploymentService(this).withDomainArtifactDeployer(new DefaultArtifactDeployer<Domain>((Supplier<Scheduler>)artifactStartExecutor)).withDomainDeploymentListener(this.domainDeploymentListener).withApplications(applications).withApplicationDeploymentListener(this.applicationDeploymentListener).withApplicationArtifactDeployer(applicationMuleDeployer).build();
        this.applicationDeployer = applicationDeployerBuilder.withApplicationDeployer(new DefaultArtifactDeployer<Application>((Supplier<Scheduler>)artifactStartExecutor)).withApplicationDeploymentListener(this.applicationDeploymentListener).withApplications(this.applications).build();
        this.applicationDeployer.setDeploymentListener(this.applicationDeploymentListener);
    }

    @Override
    public void addDeploymentListener(DeploymentListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Listener cannot be null");
        this.applicationDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDeploymentListener(DeploymentListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Listener cannot be null");
        this.applicationDeploymentListener.removeDeploymentListener(listener);
    }

    @Override
    public Application findApplication(String appName) {
        Preconditions.checkArgument((appName != null ? 1 : 0) != 0, (String)"Application name cannot be null");
        return this.applications.stream().filter(app -> app.getArtifactName().equals(appName)).findFirst().orElse(null);
    }

    @Override
    public List<Application> getApplications() {
        return this.applications;
    }

    @Override
    public Domain findDomain(String domainName) {
        Preconditions.checkArgument((domainName != null ? 1 : 0) != 0, (String)"Domain name cannot be null");
        return this.domains.stream().filter(domain -> domain.getArtifactName().contains(domainName)).findFirst().orElse(null);
    }

    @Override
    public Collection<Application> findDomainApplications(String domainName) {
        Preconditions.checkArgument((domainName != null ? 1 : 0) != 0, (String)"Domain name cannot be null");
        return this.applications.stream().filter(application -> application.getDomain() != null && application.getDomain().getArtifactName().equals(domainName)).collect(Collectors.toList());
    }

    @Override
    public List<Domain> getDomains() {
        return Collections.unmodifiableList(this.domains);
    }

    @Override
    public void addStartupListener(StartupListener listener) {
        this.startupListeners.add(listener);
    }

    @Override
    public void removeStartupListener(StartupListener listener) {
        this.startupListeners.remove(listener);
    }

    @Override
    public ReentrantLock getLock() {
        return this.deploymentLock;
    }

    @Override
    public void undeploy(String appName) {
        throw new UnsupportedOperationException("Application undeploy operation not supported");
    }

    @Override
    public void deploy(URI appArchiveUri) throws IOException {
        this.deploy(appArchiveUri, Optional.empty());
    }

    @Override
    public void deploy(URI appArchiveUri, Properties appProperties) throws IOException {
        this.deploy(appArchiveUri, Optional.ofNullable(appProperties));
    }

    private synchronized void deploy(URI appUri, Optional<Properties> deploymentProperties) throws IOException {
        block7: {
            if (!this.applications.isEmpty()) {
                throw new UnsupportedOperationException("A deployment cannot be done if there is an already deployed app in single app mode.");
            }
            try {
                File artifactLocation = this.fileResolver.resolve(appUri);
                String fileName = artifactLocation.getName();
                if (fileName.endsWith(".jar")) {
                    this.applicationDeployer.deployPackagedArtifact(appUri, deploymentProperties);
                    break block7;
                }
                if (!artifactLocation.getParent().equals(appUri.getPath())) {
                    try {
                        FileUtils.copyDirectory((File)artifactLocation, (File)new File(MuleFoldersUtil.getAppsFolder(), fileName));
                    }
                    catch (IOException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                }
                this.applicationDeployer.deployExplodedArtifact(fileName, deploymentProperties);
            }
            catch (Throwable t) {
                this.deploymentErrorConsumer.accept(t);
            }
        }
    }

    @Override
    public void redeploy(String artifactName) {
        throw new UnsupportedOperationException("Application redeploy operation not supported");
    }

    @Override
    public void redeploy(String artifactName, Properties appProperties) {
        throw new UnsupportedOperationException("Application redeploy operation not supported");
    }

    @Override
    public void redeploy(URI archiveUri, Properties appProperties) throws IOException {
        throw new UnsupportedOperationException("Application redeploy operation not supported");
    }

    @Override
    public void redeploy(URI archiveUri) throws IOException {
        throw new UnsupportedOperationException("Application redeploy operation not supported");
    }

    @Override
    public void undeployDomain(String domainName) {
        throw new UnsupportedOperationException("Domain undeploy operation not supported");
    }

    @Override
    public void deployDomain(URI domainArchiveUri) throws IOException {
        throw new UnsupportedOperationException("Domain deploy operation not supported");
    }

    @Override
    public void deployDomain(URI domainArchiveUri, Properties deploymentProperties) throws IOException {
        throw new UnsupportedOperationException("Domain deploy operation not supported");
    }

    @Override
    public void redeployDomain(String domainName, Properties deploymentProperties) {
        throw new UnsupportedOperationException("Domain redeploy operation not supported");
    }

    @Override
    public void redeployDomain(String domainName) {
        throw new UnsupportedOperationException("Domain redeploy operation not supported");
    }

    @Override
    public void deployDomainBundle(URI domainArchiveUri) throws IOException {
        throw new UnsupportedOperationException("Domain bundle deploy operation not supported");
    }

    @Override
    public void start() {
        try {
            String muleAppsPath = System.getenv(MULE_APPS_PATH_ENV);
            if (muleAppsPath != null) {
                if (muleAppsPath.toLowerCase().endsWith(".jar")) {
                    throw new IllegalArgumentException("Invalid Mule app path: '" + muleAppsPath + "'");
                }
                this.startDeployment(new File(muleAppsPath).toURI());
            } else {
                this.startDeploymentDirectoryWatcher();
            }
            this.notifyStartupListeners();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error on starting single app mode"), (Throwable)e);
        }
    }

    private void startDeployment(URI appUri) throws IOException {
        DeploymentUtils.deployExplodedDomains(this.domainDeployer);
        this.deploy(appUri);
    }

    private void startDeploymentDirectoryWatcher() {
        this.deploymentDirectoryWatcher = this.resolveDeploymentDirectoryWatcher();
        this.applicationDeploymentListener.addDeploymentListener(new DeploymentListener(){

            @Override
            public void onDeploymentSuccess(String artifactName) {
                SingleAppDeploymentService.this.deploymentDirectoryWatcher.stop();
            }

            @Override
            public void onDeploymentFailure(String artifactName, Throwable cause) {
                SingleAppDeploymentService.this.deploymentErrorConsumer.accept(cause);
            }
        });
        this.deploymentDirectoryWatcher.start();
    }

    protected DeploymentDirectoryWatcher resolveDeploymentDirectoryWatcher() {
        return new DeploymentDirectoryWatcher(new DomainBundleArchiveDeployer(this.domainBundleDeploymentListener, this.domainDeployer, this.domains, this.applicationDeployer, this.applications, this.domainDeploymentListener, this.applicationDeploymentListener, this), this.domainDeployer, this.applicationDeployer, this.domains, this.applications, this.artifactStartExecutorSupplier, this.deploymentLock, false);
    }

    public void notifyStartupListeners() {
        for (StartupListener listener : this.startupListeners) {
            try {
                listener.onAfterStartup();
            }
            catch (Throwable t) {
                LOGGER.error("Error executing startup listener {}", (Object)listener, (Object)t);
            }
        }
    }

    @Override
    public void stop() {
        if (this.deploymentDirectoryWatcher != null) {
            this.deploymentDirectoryWatcher.stop(true);
        }
    }

    @Override
    public void addDomainBundleDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDomainBundleDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.removeDeploymentListener(listener);
    }

    @Override
    public void addDomainDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDomainDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.removeDeploymentListener(listener);
    }

    @Override
    public void onDeploymentError(Consumer<Throwable> deploymentErrorConsumer) {
        this.deploymentErrorConsumer = deploymentErrorConsumer;
    }

    public DeploymentListener getApplicationDeploymentListener() {
        return this.applicationDeploymentListener;
    }

    public DeploymentListener getDomainDeploymentListener() {
        return this.domainDeploymentListener;
    }

    public List<StartupListener> getStartupListeners() {
        return this.startupListeners;
    }

    private static class StartUpDeploymentServiceScheduler
    implements Scheduler {
        private StartUpDeploymentServiceScheduler() {
        }

        public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression) {
            throw new UnsupportedOperationException("");
        }

        public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression, TimeZone timeZone) {
            throw new UnsupportedOperationException("");
        }

        public void stop() {
        }

        public String getName() {
            return "Disabled Deployment Service Scheduler";
        }

        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException("");
        }

        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException("Schedule with delay not supported");
        }

        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            throw new UnsupportedOperationException("Schedule with delay not supported");
        }

        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException("Schedule with delay not supported");
        }

        public void shutdown() {
        }

        public List<Runnable> shutdownNow() {
            return null;
        }

        public boolean isShutdown() {
            return false;
        }

        public boolean isTerminated() {
            return false;
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException("Await termination not supported");
        }

        public <T> Future<T> submit(Callable<T> task) {
            try {
                return Futures.immediateFuture(task.call());
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }

        public <T> Future<T> submit(Runnable task, T result) {
            try {
                task.run();
                return Futures.immediateFuture(result);
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }

        public Future<?> submit(Runnable task) {
            try {
                task.run();
                return Futures.immediateFuture(null);
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }

        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
            return tasks.stream().map(this::submit).collect(Collectors.toList());
        }

        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
            return tasks.stream().map(this::submit).collect(Collectors.toList());
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException {
            try {
                return tasks.iterator().next().call();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException {
            try {
                return tasks.iterator().next().call();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }

        public void execute(Runnable command) {
            command.run();
        }
    }
}

