/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerAlreadyExistsException;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.ContextHttpServerConnectionFactory;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.ServerIdentifier;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.impl.server.util.HttpServerAdapter;
import org.mule.service.http.netty.impl.util.SslContextHelper;

public class HttpServerConnectionManager
implements ContextHttpServerConnectionFactory {
    private static final int SERVER_SELECTOR_THREAD_COUNT = Integer.getInteger("mule.http.server.selectors.count", Integer.max(Runtime.getRuntime().availableProcessors(), 4));
    private final Map<ServerIdentifier, HttpServer> servers = new ConcurrentHashMap<ServerIdentifier, HttpServer>();
    private final SchedulerService schedulerService;

    public HttpServerConnectionManager(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Override
    public HttpServer create(HttpServerConfiguration configuration, String context, Supplier<Long> shutdownTimeout) throws ServerCreationException {
        String name = configuration.getName();
        ServerIdentifier nameAndContext = new ServerIdentifier(name, context);
        HttpServer alreadyPresent = this.servers.get(nameAndContext);
        if (alreadyPresent != null) {
            throw new ServerAlreadyExistsException(alreadyPresent.getServerAddress());
        }
        HttpServer created = this.createServer(nameAndContext, configuration, shutdownTimeout);
        this.servers.putIfAbsent(nameAndContext, created);
        return created;
    }

    @Override
    public HttpServer lookup(String name, String context) throws ServerNotFoundException {
        HttpServer server = this.servers.get(new ServerIdentifier(name, context));
        if (null == server) {
            throw new ServerNotFoundException(name);
        }
        return new NoLifecycleHttpServer(server);
    }

    @Override
    public HttpServer getOrCreateServer(String name, String context, Supplier<? extends HttpServerConfiguration> configuration, Supplier<Long> shutdownTimeout) throws ServerCreationException {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Server name can't be null");
        try {
            return this.servers.computeIfAbsent(new ServerIdentifier(name, context), pair -> this.createServer((ServerIdentifier)pair, (HttpServerConfiguration)configuration.get(), shutdownTimeout));
        }
        catch (MuleRuntimeException e) {
            throw new ServerCreationException(e.getMessage(), (Throwable)e);
        }
    }

    private HttpServer createServer(ServerIdentifier nameAndContext, HttpServerConfiguration configuration, Supplier<Long> shutdownTimeout) throws MuleRuntimeException {
        try {
            Preconditions.checkArgument((nameAndContext.serverName() != null ? 1 : 0) != 0, (String)"Server name can't be null");
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"Server configuration can't be null");
            HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
            SslContext sslContext = SslContextHelper.sslContextForServer(configuration.getTlsContextFactory(), configuration.getHttp1Config().isEnabled(), configuration.getHttp2Config().isEnabled());
            Scheduler selectorsScheduler = this.createSelectorsScheduler();
            Scheduler ioScheduler = this.createIOScheduler();
            NettyHttpServer.Builder builder = NettyHttpServer.builder().withName(configuration.getName()).withServerAddress(new InetSocketAddress(configuration.getHost(), configuration.getPort())).withHttpListenerRegistry(httpListenerRegistry).withSslContext(sslContext).withSelectorsScheduler(selectorsScheduler).withSelectorsCount(SERVER_SELECTOR_THREAD_COUNT).withShutdownTimeout(shutdownTimeout).doOnDispose(() -> this.servers.remove(nameAndContext));
            return this.enrichServerBuilder(builder, httpListenerRegistry, configuration, sslContext, (ExecutorService)ioScheduler).build();
        }
        catch (IllegalArgumentException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Scheduler createSelectorsScheduler() {
        if (this.schedulerService == null) {
            return null;
        }
        return this.schedulerService.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(SERVER_SELECTOR_THREAD_COUNT).withName("http.listener"), 0);
    }

    private Scheduler createIOScheduler() {
        if (this.schedulerService == null) {
            return null;
        }
        return this.schedulerService.ioScheduler(SchedulerConfig.config().withName("http.listener.io"));
    }

    protected NettyHttpServer.Builder enrichServerBuilder(NettyHttpServer.Builder builder, HttpListenerRegistry listenerRegistry, HttpServerConfiguration configuration, SslContext sslContext, ExecutorService ioExecutor) {
        return builder.withClientChannelHandler(new AcceptedConnectionChannelInitializer(listenerRegistry, configuration, sslContext, ioExecutor));
    }

    private static class NoLifecycleHttpServer
    extends HttpServerAdapter {
        public NoLifecycleHttpServer(HttpServer delegate) {
            super(delegate);
        }

        @Override
        public HttpServer start() {
            return this;
        }

        @Override
        public HttpServer stop() {
            return this;
        }

        @Override
        public void dispose() {
        }
    }
}

