/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.util.Logger;
import reactor.util.Loggers;

final class ChannelOperationsHandler
extends ChannelInboundHandlerAdapter {
    final ConnectionObserver listener;
    final ChannelOperations.OnSetup opsFactory;
    static final Logger log = Loggers.getLogger(ChannelOperationsHandler.class);

    ChannelOperationsHandler(ChannelOperations.OnSetup opsFactory, ConnectionObserver listener) {
        this.listener = listener;
        this.opsFactory = opsFactory;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            Connection c = Connection.from(ctx.channel());
            this.listener.onStateChange(c, ConnectionObserver.State.CONNECTED);
            ChannelOperations<?, ?> ops = this.opsFactory.create(c, this.listener, null);
            if (ops != null) {
                ops.bind();
                this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
            }
        }
    }

    public final void channelInactive(ChannelHandlerContext ctx) {
        try {
            Connection connection = Connection.from(ctx.channel());
            ChannelOperations ops = connection.as(ChannelOperations.class);
            if (ops != null) {
                ops.onInboundClose();
            } else {
                this.listener.onStateChange(connection, ConnectionObserver.State.DISCONNECTING);
            }
        }
        catch (Throwable err) {
            this.exceptionCaught(ctx, err);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        SslCloseCompletionEvent sslCloseCompletionEvent;
        if (evt instanceof SslCloseCompletionEvent && (sslCloseCompletionEvent = (SslCloseCompletionEvent)evt).isSuccess() && ctx.channel().isActive()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(ctx.channel(), "Received a TLS close_notify, closing the channel now."));
            }
            ctx.close();
        }
        ReferenceCountUtil.release((Object)evt);
    }

    public final void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg == null || msg == Unpooled.EMPTY_BUFFER || msg instanceof EmptyByteBuf) {
            return;
        }
        try {
            Connection connection = Connection.from(ctx.channel());
            ChannelOperations ops = connection.as(ChannelOperations.class);
            if (ops != null) {
                ops.onInboundNext(ctx, msg);
            } else {
                DecoderResult decoderResult;
                if (msg instanceof DecoderResultProvider && (decoderResult = ((DecoderResultProvider)msg).decoderResult()).isFailure()) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format(ctx.channel(), "Decoding failed."), decoderResult.cause());
                    }
                    ctx.close();
                    this.listener.onUncaughtException(connection, decoderResult.cause());
                }
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(ctx.channel(), "No ChannelOperation attached."));
                }
                ReferenceCountUtil.release((Object)msg);
            }
        }
        catch (Throwable err) {
            ChannelOperationsHandler.safeRelease(msg);
            log.error(ReactorNetty.format(ctx.channel(), "Error was received while reading the incoming data. The connection will be closed."), err);
            ctx.close();
            this.exceptionCaught(ctx, err);
        }
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable err) {
        Connection connection = Connection.from(ctx.channel());
        ChannelOperations ops = connection.as(ChannelOperations.class);
        if (ops != null) {
            ops.onInboundError(err);
        } else {
            this.listener.onUncaughtException(connection, err);
        }
    }

    public final void channelWritabilityChanged(ChannelHandlerContext ctx) {
        ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
        if (ops != null) {
            ops.onWritabilityChanged();
        }
    }

    static void safeRelease(Object msg) {
        block3: {
            ReferenceCounted referenceCounted;
            if (msg instanceof ReferenceCounted && (referenceCounted = (ReferenceCounted)msg).refCnt() > 0) {
                try {
                    referenceCounted.release();
                }
                catch (IllegalReferenceCountException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("", (Throwable)e);
                }
            }
        }
    }
}

