/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.providers.grizzly.TransportCustomizer;
import java.util.concurrent.ExecutorService;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;

public class IOStrategyTransportCustomizer
implements TransportCustomizer {
    private static final boolean USE_WORKER_THREAD_IO_STRATEGY_WHEN_TLS_ENABLED = Boolean.parseBoolean(System.getProperty("mule.https.forceWorkerThreadIoStrategy"));
    private final boolean streamingEnabled;
    private ExecutorService selectorPool;
    private ExecutorService workerPool;
    private int selectorCount;
    private final boolean tlsEnabled;

    public IOStrategyTransportCustomizer(ExecutorService selectorPool, ExecutorService workerPool, boolean streamingEnabled, int selectorCount, boolean tlsEnabled) {
        this.selectorPool = selectorPool;
        this.workerPool = workerPool;
        this.streamingEnabled = streamingEnabled;
        this.selectorCount = selectorCount;
        this.tlsEnabled = tlsEnabled;
    }

    public void customize(TCPNIOTransport transport, FilterChainBuilder filterChainBuilder) {
        boolean forceWorkerThreadStrategy = USE_WORKER_THREAD_IO_STRATEGY_WHEN_TLS_ENABLED && this.tlsEnabled;
        transport.setIOStrategy((IOStrategy)(this.streamingEnabled || forceWorkerThreadStrategy ? WorkerThreadIOStrategy.getInstance() : SameThreadIOStrategy.getInstance()));
        transport.setKernelThreadPool(this.selectorPool);
        transport.setWorkerThreadPool(this.workerPool);
        transport.setSelectorRunnersCount(this.selectorCount);
    }
}

