/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.StringNode;

public class JSonDumper {
    public static String dump(Node node) {
        return JSonDumper.dumpNode(node);
    }

    private static String dump(Node node, String start, String separator, String end) {
        StringBuilder builder = new StringBuilder();
        List<String> children = JSonDumper.dumpChildren(node.getChildren());
        builder.append(start).append(StringUtils.join(children, (String)separator)).append(end);
        return builder.toString();
    }

    private static List<String> dumpChildren(List<Node> children) {
        ArrayList valueChildren = Lists.newArrayList();
        for (Node child : children) {
            valueChildren.add(JSonDumper.dumpNode(child));
        }
        return valueChildren;
    }

    private static String dumpNode(Node child) {
        if (child instanceof KeyValueNode) {
            KeyValueNode keyValueNode = (KeyValueNode)child;
            return JSonDumper.dumpNode(keyValueNode.getKey()) + " : " + JSonDumper.dumpNode(keyValueNode.getValue());
        }
        if (child instanceof ObjectNode) {
            return JSonDumper.dump(child, "{\n", ",\n", "\n}");
        }
        if (child instanceof StringNode) {
            return "\"" + ((StringNode)child).getValue() + "\"";
        }
        if (child instanceof ArrayNode) {
            return JSonDumper.dump(child, "[\n", ",\n", "\n]");
        }
        return child.toString();
    }
}

