/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.documentation;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.module.extension.api.resources.documentation.ExtensionDescriptionSerializerException;
import org.mule.runtime.module.extension.api.resources.documentation.ExtensionDescriptionsSerializer;
import org.mule.runtime.module.extension.api.resources.documentation.XmlExtensionDocumentation;
import org.mule.runtime.module.extension.internal.resources.documentation.DefaultXmlExtensionDocumentation;

public class DefaultExtensionDescriptionsSerializer
implements ExtensionDescriptionsSerializer {
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;
    private final Transformer transformer;

    public DefaultExtensionDescriptionsSerializer() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(DefaultExtensionDescriptionsSerializer.class.getClassLoader());
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DefaultXmlExtensionDocumentation.class});
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (Exception e) {
            throw new ExtensionDescriptionSerializerException("Failed to initialize XML serialization components", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        try {
            this.transformer = XMLSecureFactories.createDefault().getTransformerFactory().newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("cdata-section-elements", "description");
        }
        catch (Exception e) {
            throw new ExtensionDescriptionSerializerException("Failed to initialize XML serialization components", e);
        }
    }

    @Override
    public synchronized String serialize(XmlExtensionDocumentation dto) {
        try {
            DOMResult domResult = new DOMResult();
            this.marshaller.marshal((Object)dto, (Result)domResult);
            StringWriter writer = new StringWriter();
            this.transformer.transform(new DOMSource(domResult.getNode()), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            throw new ExtensionDescriptionSerializerException("Failed to serialize XML documentation", e);
        }
    }

    @Override
    public synchronized XmlExtensionDocumentation deserialize(String xml) {
        return this.deserialize(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public synchronized XmlExtensionDocumentation deserialize(InputStream xml) {
        try {
            return (DefaultXmlExtensionDocumentation)this.unmarshaller.unmarshal(xml);
        }
        catch (Exception e) {
            throw new ExtensionDescriptionSerializerException("Failed to deserialize XML documentation from stream", e);
        }
    }

    @Override
    public String getFileName(String extensionName) {
        String key = extensionName.replace(" ", "-").toLowerCase();
        return String.format("%s-extension-descriptions.xml", key);
    }
}

