/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.utils;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Base64;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;

public class NtlmLoginAuthenticator
extends LoginAuthenticator {
    public static final String NTLM_HEADER_PREFIX = "NTLM ";

    public String getAuthMethod() {
        return "NTLM";
    }

    public Authentication validateRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean b) throws ServerAuthException {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String authHeader = request.getHeader(HttpHeader.AUTHORIZATION.asString());
            if (authHeader == null) {
                response.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), this.getAuthMethod());
                return Authentication.UNAUTHENTICATED;
            }
            if (NtlmLoginAuthenticator.isNtlmTypeN(authHeader, 1)) {
                response.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), this.createType2Header(authHeader));
                return Authentication.UNAUTHENTICATED;
            }
            if (NtlmLoginAuthenticator.isNtlmTypeN(authHeader, 3)) {
                return Authentication.SEND_SUCCESS;
            }
            return Authentication.UNAUTHENTICATED;
        }
        catch (Exception e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    private static boolean isNtlmTypeN(String header, int n) {
        if (!header.startsWith(NTLM_HEADER_PREFIX)) {
            return false;
        }
        String base64 = header.substring(5);
        byte[] asByteArray = Base64.getDecoder().decode(base64);
        byte type = asByteArray[8];
        return type == n;
    }

    String createType2Header(String type1Header) throws IOException {
        String base64 = type1Header.substring(5);
        byte[] type1AsByteArray = Base64.getDecoder().decode(base64);
        Type1Message type1Message = new Type1Message(type1AsByteArray);
        Type2Message type2Message = new Type2Message(type1Message);
        String encoded = Base64.getEncoder().encodeToString(type2Message.toByteArray());
        return NTLM_HEADER_PREFIX + encoded;
    }

    public boolean secureResponse(ServletRequest servletRequest, ServletResponse servletResponse, boolean b, Authentication.User user) throws ServerAuthException {
        return true;
    }
}

