/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.common.message.sse;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.http.api.sse.ServerSentEvent;

public class ServerSentEventImpl
implements Serializable,
ServerSentEvent {
    private static final long serialVersionUID = -1211505868025654629L;
    private final String eventName;
    private final String eventData;
    private final String id;
    private final Long retryDelay;

    public ServerSentEventImpl(String eventName, String eventData, String id, Long retryDelay) {
        Objects.requireNonNull(eventName, "eventName cannot be null");
        Objects.requireNonNull(eventData, "eventData cannot be null");
        this.eventName = eventName;
        this.eventData = eventData;
        this.id = id;
        this.retryDelay = retryDelay;
    }

    public String getName() {
        return this.eventName;
    }

    public String getData() {
        return this.eventData;
    }

    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public Optional<Long> getRetryDelay() {
        return Optional.ofNullable(this.retryDelay);
    }

    public String toString() {
        return "ServerSentEvent [name=" + this.eventName + ", data=" + this.eventData + ", id=" + this.id + ", retryDelay=" + this.retryDelay + "]";
    }

    public int hashCode() {
        return Objects.hashCode(this.eventName) + Objects.hashCode(this.eventData) + Objects.hashCode(this.id) + Objects.hashCode(this.retryDelay);
    }

    public boolean equals(Object o) {
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        ServerSentEventImpl that = (ServerSentEventImpl)o;
        return Objects.equals(this.eventName, that.eventName) && Objects.equals(this.eventData, that.eventData) && Objects.equals(this.id, that.id) && Objects.equals(this.retryDelay, that.retryDelay);
    }
}

