/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.internal.exception.MessagingExceptionResolver;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorParameterValue;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.MessagingException;

class AbstractInterceptorAdapter {
    @Inject
    private MuleContext muleContext;
    @Inject
    protected ErrorTypeLocator errorTypeLocator;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    @Inject
    protected ExtendedExpressionManager expressionManager;

    AbstractInterceptorAdapter() {
    }

    protected Map<String, ProcessorParameterValue> getResolvedParams(InternalEvent eventWithResolvedParams) {
        Map params = (Map)eventWithResolvedParams.getInternalParameter("core:interceptionResolvedParams");
        if (params == null) {
            return Collections.emptyMap();
        }
        return params;
    }

    protected InternalEvent addResolvedParameters(InternalEvent event, Component component, Map<String, String> dslParameters) {
        boolean sameComponent;
        boolean bl = sameComponent = this.internalParametersFrom(event).containsKey("core:interceptionComponent") ? component.equals(this.internalParametersFrom(event).get("core:interceptionComponent")) : false;
        if (!sameComponent || !this.internalParametersFrom(event).containsKey("core:interceptionResolvedParams")) {
            return this.resolveParameters(this.removeResolvedParameters(event), component, dslParameters);
        }
        return event;
    }

    protected InternalEvent removeResolvedParameters(InternalEvent event) {
        return InternalEvent.builder(event).removeInternalParameter("core:interceptionResolvedParams").removeInternalParameter("core:interceptionComponent").removeInternalParameter("core:interceptionResolvedContext").build();
    }

    protected Map<String, ?> internalParametersFrom(CoreEvent event) {
        return ((InternalEvent)event).getInternalParameters();
    }

    protected InternalEvent resolveParameters(InternalEvent event, Component component, Map<String, String> parameters) {
        Map resolvedParameters = SmallMap.forSize((int)parameters.size());
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String providedValue = entry.getValue();
            resolvedParameters.put(entry.getKey(), new DefaultProcessorParameterValue(entry.getKey(), providedValue, () -> {
                if (this.expressionManager.isExpression(providedValue)) {
                    return this.expressionManager.evaluate(providedValue, (CoreEvent)event, component.getLocation()).getValue();
                }
                return String.valueOf(providedValue);
            }));
        }
        return this.setInternalParamsForNotParamResolver(component, resolvedParameters, event, InternalEvent.builder(event));
    }

    protected InternalEvent setInternalParamsForNotParamResolver(Component component, Map<String, ProcessorParameterValue> resolvedParameters, InternalEvent event, InternalEvent.Builder builder) {
        return EventQuickCopy.quickCopy(event, (Map<String, Object>)SmallMap.of((Object)"core:interceptionResolvedParams", resolvedParameters, (Object)"core:interceptionComponent", (Object)component));
    }

    protected MessagingException createMessagingException(CoreEvent event, Throwable cause, Component processor, Optional<MessagingException> original) {
        MessagingException me = new MessagingException(event, cause, processor);
        original.ifPresent(error -> error.getInfo().forEach((arg_0, arg_1) -> ((MessagingException)me).addInfo(arg_0, arg_1)));
        return me;
    }

    protected MessagingException resolveMessagingException(CoreEvent event, Throwable cause, Component processor, Optional<MessagingException> original) {
        return new MessagingExceptionResolver(processor).resolve(this.createMessagingException(event, cause, processor, original), this.errorTypeLocator, this.exceptionContextProviders);
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }
}

